// detection.cpp - setup and handle DETECTION services

#include "detection.h"


// declare a CharacteristicDataInitializer which can be used to initialize
// all our characteristics

   CharacteristicInitializer ini;
   
// Detection Service

   Service detection(0xA010,"Detection"); // Detection Service
   Characteristic<Bool>        chrPresence(detection,0xA011, "n", "Presence"); 

// Address Service

   Service address(0xA020,"Address");   // Address Service
   Characteristic<ObjectId>    chrId     (address, 0xA021, "na", "ID"); 
   //Characteristic<ObjectName>  chrName   (address, 0xA022, "na", "Name"); 
   //Characteristic<ObjectName>   chrLayout (address, 0xA023, "na", "Layout"); 

      // here is the issue: if above declaration of the characteristic chrName
      // is being uncommented the GATT database will be corrupted. It has been 
      // found out by trial & error that below 'tedious' code is a fix.
/*      
   UserDescriptor(nameLayout,attLayout,dscLayout,"Layout")
   static ReadOnlyGattCharacteristic<ObjectName> _chrLayout(0xA023,ini.pObjectName(),0,dscLayout,1);   

   static GattCharacteristic *addressList[] = {&chrId,&chrName,&_chrLayout};
   static GattService _address(0xA020, addressList, GattListLength(addressList));
*/
// Debug Service

   Service debug(0xA030,"Debug");      // Debug Service
   Characteristic<Bool>        chrTest      (debug, 0xA031, "w", "Test"); 
   Characteristic<DateTime>    chrTimestamp (debug, 0xA032, "r", "Timestamp"); 

//==============================================================================
// Update Callback
//==============================================================================

   static void cbWritten(Blob &o)            // handle updates
   {
      Bool value;  
      
      if (updated(o,chrTest))          // has chrTest been updated?
      {
         get(o,chrTest,value);         // get value of chrTest
         set(o,chrPresence,value);     // and store this value to chrPresence 

         print(o,value,"test");
         if (value == 0)
            blinkConnected(o,"x x          ");
         else if (value == 1)
            blinkConnected(o,"xxx xxx          ");
         else
            blinkConnected(o,"x xxx x xxx          ");
      }
      else if (updated(o,chrPresence)) // has chrPresence been updated?
      {  
         get(o,chrPresence,value);      
         print(o,value,"test");
      }
   }

//==============================================================================
// Register Services and Callbacks
//==============================================================================

   void services(Blob &o)              // enroll all services & characteristics
   {
      enroll(o,detection);             // enroll Detection Service
      enroll(o,address);               // enroll Address Service
      enroll(o,debug);                 // enroll Debug Service
      
      onWritten(o,cbWritten);          // setup 'data written' callback
   }

//eof