// tedious.cpp - tedious setup and handling of DETECTION services

#include "detection.h"

// declare a CharacteristicDataInitializer which can be used to initialize
// all our characteristics

   static CharacteristicInitializer ini;
   
// Detection Service
//
//    Service detection(0xA010,"Detection"); // Detection Service
//    Characteristic<Bool>        chrPresence(detection,0xA011, "n", "Presence"); 

   UserDescriptor(namePresense,attPresence,dscPresence,"Presence")
   static ReadOnlyGattCharacteristic<Bool> chrPresence(0xA011,ini.pBool(),0,dscPresence,1);   

   static GattCharacteristic *detectionList[] = {&chrPresence};
   static GattService detection(0xA010, detectionList, GattListLength(detectionList));

// Address Service
//
//    Service address(0xA020,"Address");
//    Characteristic<ObjectId>    chrId     (address, 0xA021, "na", "ID"); 
//    Characteristic<ObjectName>  chrName   (address, 0xA022, "na", "Name"); 
//    Characteristic<Bool>        chrLayout (address, 0xA023, "na", "Layout"); 

   UserDescriptor(nameId,attId,dscId,"ID")
   static WriteOnlyGattCharacteristic<ObjectId> chrId(0xA021,ini.pObjectId(),0,dscId,1);   

   UserDescriptor(nameName,attName,dscName,"Name")
   static ReadOnlyGattCharacteristic<ObjectName> chrName(0xA022,ini.pObjectName(),0,dscName,1);   
      
   UserDescriptor(nameLayout,attLayout,dscLayout,"Layout")
   static ReadOnlyGattCharacteristic<ObjectName> chrLayout(0xA023,ini.pObjectName(),0,dscLayout,1);   

   static GattCharacteristic *addressList[] = {&chrId,&chrName,&chrLayout};
   static GattService address(0xA020, addressList, GattListLength(addressList));

// Debug Service
//
//    Service debug(0xA030,"Debug");
//    Characteristic<Bool>        chrTest      (debug, 0xA031, "w", "Test"); 
//    Characteristic<DateTime>    chrTimestamp (debug, 0xA032, "r", "Timestamp"); 

   UserDescriptor(nameTest,attTest,dscTest,"Test")
   static WriteOnlyGattCharacteristic<Bool> chrTest(0xA031,ini.pBool(),0,dscTest,1);   

   UserDescriptor(nameTimeStamp,attTimeStamp,dscTimeStamp,"TimeStamp")
   static ReadOnlyGattCharacteristic<DateTime> chrTimeStamp(0xA032,ini.pDateTime(),0,dscTimeStamp,1);   
      
   static GattCharacteristic *debugList[] = {&chrTest,&chrTimeStamp};
   static GattService debug(0xA030, debugList, GattListLength(debugList));


//==============================================================================
// Update Callback
//==============================================================================

   static void cbWritten(Blob &o)            // handle updates
   {
      Bool value;  
      
      if (updated(o,chrTest))          // has chrTest been updated?
      {
         get(o,chrTest,value);         // get value of chrTest
         set(o,chrPresence,value);     // and store this value to chrPresence 

         print(o,value,"test");
         if (value == 0)
            blinkConnected(o,"x x          ");
         else if (value == 1)
            blinkConnected(o,"xxx xxx          ");
         else
            blinkConnected(o,"x xxx x xxx          ");
      }
      else if (updated(o,chrPresence)) // has chrPresence been updated?
      {  
         get(o,chrPresence,value);      
         print(o,value,"test");
      }
   }

//==============================================================================
// Register Services and Callbacks
//==============================================================================

   void tediousServices(Blob &o)       // enroll all services & characteristics
   {
      enroll(o,detection,0xA010);
      enroll(o,address,0xA020);
      enroll(o,debug,0xA030);
      
      onWritten(o,cbWritten);          // setup 'data written' callback
   }

//eof