// service.h - declaring services and definitions
//
// Synopsis
//
// Example 1: A protocol might be declared as a class as follows
//
//    Collection col;                            // collection used during setup
//
//    Characteristic<ObjectId>   id(col,0x2AC3,"rw","ID");
//    Characteristic<ObjectName> name(col,0x2ABE,"rw","Name");
//    Characteristic<Digital>    presence(col,0x2A56,"r","Presence");
//
//    Service presenceDetection(col,0xA001);     // instantiate service
//
//    onSetup(Blob &blue)
//    {
//       blue.service(presenceDetection);        // use service    
//    }
//
// Example 2: service definition by means of a service definition class
//
//   class PresenceDetector
//   {
//      public:
//         Collection col;                       // collection used during setup 
//
//         Characteristic<ObjectId> id;          // ID of presence detector
//         Characteristic<ObjectName> name;      // name of presence detector
//         Characteristic<Digital> presence;     // digital presence value
//         Characteristic<DateTime> timestamp;   // last detection change's time
//         Characteristic<ObjectName> layout;    // name of model railway layout
//
//         Service presenceDetection;            // the service
//
//      public:
//         PresenceDetector(Blob &blue, cost UUID uuid) :
//            list;                              // init service list
//            id(list,0x2AC3,"rw","ID"),         // instantiate characteristic
//            name(list,0x2ABE,"rw","Name"),     // instantiate characteristic
//            presence(list,0x2A56,"r","Presence"),// instantiate characteristic
//            timestamp(list,0x2A08,"r","Timestamp"),// instantiate characteristic
//            layout(list,0x2ABE,"rw","Layout"), // instantiate characteristic
//            presenceDetection(list,uuid)       // instantiate service
//         {
//            Blob blue;    
//            blue.service(presenceDetection);   // use service    
//         }
//   };       
//
#ifndef _SERVICE_H_
#define _SERVICE_H_

#include "ble/BLE.h"
#include "ble/Gap.h"
#include "bricks/blob.h"
#include "bricks/collection.h"

      // the following #define is helpful if a service is defined on base of the
      // BLE API (the tedios way)
   
#define GattListLength(list) (sizeof(list)/sizeof(GattCharacteristic*))

      // Service classs definition
      
   class Service
   {
      public:                               // public properties
         Collection collection;             // collection of characteristics
         uint16_t uuid;                     // UUID of service
         const char *name;                  // name of service
         
      public:                               // public methods
         Service(uint16_t _uuid, const char* _name = NULL) : collection()
         {
             uuid = _uuid;
             name = _name;
         }
         
         void add(GattCharacteristic *pChr) // add a characteristic to collection
         {
             collection.add(pChr);
         }
   };

#endif // _SERVICE_H_