// S13_TOF_GAP - ToF Sensor @ GAP based on X-NUCLEO-6180XA1 Board

#include <mbed.h>
#include "bricks/bricks.h"
#include "bricks/blinker.h"
//#include "bricks/stop.h"
#include "shields/shields.h"

   typedef DisplayShield Dish;         // a short hand for DisplayShield

   Dish *pShield;                      // to access our 6180XA1 DIsplay SHield
   //StopButton  stop(USER_BUTTON);      // press blue button for stop

//==============================================================================
// Data Ready Callback
//==============================================================================

   static void cbReady(void)           // called if measurement done, data ready
   {
       pShield->ready();               // forward IRQ callback to ready()
   }

//==============================================================================
// Simple Loop - Cannot Change Mode
//==============================================================================

   void loop(Dish &o)
   {
      int err = o.start(cbReady);      // start measuement callback @ cbReady

      if (err == 0)
      {
//       while ( !stop.request() )
         {
            if( o.request() )          // data service requested by 6180XA1 IRQ?
               o.handle();             // handle data transfer

            o.refresh();               // refresh display
         }
         o.stop();                     // stop all current measurements
      }
//    stop.clear();                    // clear stop request (of stop button)
   }    

//==============================================================================
// Some Callbacks
//==============================================================================

   void cbDisconnect(O&o)              // disconnection callback
   {
      advertise(o);                    // start advertising
      blinkAdvertise(o);               // indicate advertising
   }


   void cbError(O&o)                   // Error Reporting Callback
   {
      blinkError(o);                   // indicate an error
   }    


   void cbSetup(O&o)                   // setup calback (after BLE init)
   {
      device(o,"S13#1.0_TOF_GAP");     // setup device name
      name(o,"TOF Detector");          // add name to device
      data(o,"123");                   // advertising user data

      onDisconnect(o,cbDisconnect);    // setup disconnection callback

      payload(o,"C:ng");               // no BR/EDR, general discoverable (UDSN)
      advertise(o,100);                // start advertising @ 100 msec interval
      blinkAdvertise(o);               // indicate advertising mode
   }


   int main()
   {
      O o;                             // Our Blob (BLuetooth OBject)
      verbose(o);                      // verbose talking (all levels)
      blinkIdle(o);                    // idle blinking - everything is OK!

      init(o,cbSetup,cbError);         // init BLE base layer, always do first

      while (true)                     // Infinite loop waiting for BLE events
         sleep(o);                     // low power waiting for BLE events 
/*
      pShield = new Dish;              // create a DIsplay SHield class instance
      pShield->init("ToF",1000);
      
      Dish &sh = *pShield;              // short hand
      
      sh.setup(InterruptTOF);           // setup fot ToF measurement only
      loop(sh);      
      sh.display("BYE",2000);           // display "byE" for 2 seconds
*/      
   }
