// trace.cpp - trace a message depending on verbose level
//

#include <stdio.h>
#include "bricks/trace.h"

   static Serial pc(USBTX, USBRX);     // serial port to PC terminal

//==============================================================================
// Managing the Verbose Lewvel
//==============================================================================

   static int threshold = 0;           // verbose threshold, no verbose messages
  
   void verbose(O&o, int level)        // setup verbose level               
   {
      threshold = level;               // update verbose threshold
   }
   
//==============================================================================
// Printing Trace Messages
//==============================================================================

   void trace(O&o, int level, const char *msg) // trace a message
   {
      if (level <= threshold)          // update verbose threshold
      {  char buf[2] = " ";            // must be terminated
         
         for (; *msg; msg++)
         {  buf[0] = *msg;  
            printf(buf);
            if (*msg == '\n')
            {  buf[0] = '\r';          // auto adding carriage return
               printf(buf);
            }
         }
      }
   }
   
   void trace(O&o, int level, const char*format, int value)
   {
       char buf[80];
       if (strlen(format) > 70)
          trace(o,level," *** buffer overflow *** ");
       else
       {  sprintf(buf,format,value);
          trace(o,level,buf);
       }
   }

   void traceln(O&o, int level, const char*msg)  // trace with CR & LF
   {
       trace(o,level,msg);  trace(o,level,"\r\n");
   }
