// N06_NAND: demonstration of 'NAND' GATT service
// Program has been tested on nRF51822-DK
 
#include "bricks/bricks.h"

   Service tiny(0xA000,"Tiny");        // Tiny Service
   Characteristic<Digital>  chrInput1(tiny, 0xA001, "w", "Input1"); 
   Characteristic<Digital>  chrInput2(tiny, 0xA002, "w", "Input2"); 
   Characteristic<Digital>  chrOutput(tiny, 0xA003, "n", "Output"); 

   void cbWritten(O&o)                 // data written callback
   {
      Digital in1, in2, out;           // need some local variables
      
      if (updated(o,chrInput1) || updated(o,chrInput2))  // changed inputs?
      {
         get(o,chrInput1,in1);         // get value of Input1 characteristics
         get(o,chrInput2,in2);         // get value of Input2 characteristics
         out = !(in1 && in2);          // perform NAND (Not AND) operation
         set(o,chrOutput,out);         // store result to Output characteristics
      }
   }

   void cbDisconnect(O&o)              // disconnection callback
   {
      advertise(o);                    // resume advertising on disconnection
   }
   
   int main(void)
   {
      O o;                             // Oh-ohh - our Blob (BLuetooth OBject)
      init(o);                         // init BLE base layer, always do first

      onDisconnect(o,cbDisconnect);    // setup disconnection callback
      onWritten(o,cbWritten);          // setup data written callback
      
      device(o,"NAND Gate");           // setup device name
      name(o,"N06#2.0 NAND");          // add name to device
      enroll(o,tiny);                  // enroll (register) TINY service

      advertise(o,"C:ng",100);         // start advertising @ 100 msec interval

      for(;;) sleep(o);                // low power waiting for BLE events 
   }