// S05_Advertising: Tutorial for demonstration of simple advertising
// Program has been tested on NUCLEO-L476RG
 
#include "bricks/bricks.h"

      // Add a device name for human readability

   const static char     DEVICE_NAME[] = "Stupid Board";

      // You have up to 26 bytes of advertising data to use.
      // Hex data example: {0x01,0x02,0x03,0x04,0x05}
      // Char data example: {"ChangeThisData"}

   const static uint8_t AdvData[] = {0x01,0x02,0x03,0x04,0x05}; 

//==============================================================================
// Some Callbacks
//==============================================================================

   void cbDisconnect(O&o)              // disconnection callback
   {
      advertise(o);                    // start advertising
      blinkAdvertise(o);               // indicate advertising
   }


   void cbError(O&o)                   // Error Reporting Callback
   {
      blinkError(o);                   // indicate an error
   }    


   void cbSetup(O&o)                   // setup calback (after BLE init)
   {
      device(o,DEVICE_NAME);           // setup device name
      name(o,"S05#1.0 Advertise");     // add name to device
      data(o,AdvData,sizeof(AdvData)); // advertising user data

      onDisconnect(o,cbDisconnect);    // setup disconnection callback

      payload(o,"C:ng");               // no BR/EDR, general discoverable (UDSN)
      advertise(o,100);                // start advertising @ 100 msec interval
      blinkAdvertise(o);               // indicate advertising mode
   }


   int main(void)
   {
      O o;                             // Our Blob (BLuetooth OBject)
      verbose(o);                      // verbose talking (all levels)
      blinkIdle(o);                    // idle blinking - everything is OK!

      init(o,cbSetup,cbError);         // init BLE base layer, always do first
      
      while (true)                     // Infinite loop waiting for BLE events
         sleep(o);                     // low power waiting for BLE events 
   }
