// sleep.h - sleep for some time
//
// Synopsis:
//
//    void sleep(Blob &o)              // low energy sleep for some mili seconds
//    void sleep(Blob &o, int ms)      // low enery sleep, handle BLE events
//
// Arguments:
//
//    o:        Blob object (to avoid name clashes)
//    msec:     sleeping interval in miliseconds
//
// Description:
//
//
// Example 1: main function body to setup BLE functionality
//
//    main(void)
//    {
//       Blob o;                       // our Blob object
//       init(o,onSetup,onError);      // init BLE base layer, always do first
//      
//       while (true)                  // Infinite loop waiting for BLE events
//          sleep(o);                  // low power waiting for BLE events 
//    }
//
// Example 2: Turn LED on for 2 seconds miliseconds
//
//    led = 1;                         // turn LED on
//    sleep(o,2000);                   // wait 2000 miliseconds (in LE mode) 
//    led = 0;                         // turn LED off
//
// See also: BLOB, INIT
//
#ifndef _SLEEP_H_
#define _SLEEP_H_

#include "bricks/blob.h"

   inline void sleep(Blob &o)          // low power waiting for BLE events 
   {
      o.waitForEvent();                // low power waiting for BLE events 
   }
   
   inline void sleep(Blob &o, int ms)  // low power waiting for BLE events 
   {
      wait_ms(ms);                     // low power waiting for some miliseconds 
   }

#endif // _SLEEP_H_