// init.cpp - initialize BLE system

#include "bricks/init.h"
#include "bricks/blink.h"
#include "bricks/trace.h"

   static void (*cbSetup)(O&o) = 0;            // setup callback 
   static void (*cbError)(O&o) = 0;            // error callback 

   static void cbDefaultError(O&o)             // default error handler
   {
       blinkError(o);                          // 'error' blink sequence
   }
   
   static void initComplete(BLE::InitializationCompleteCallbackContext *params)
   {
      Blob o;                          // setup a blob
      o.pComplete = params;            // store to provide access
 
      // params->error = (ble_error_t)((int)BLE_ERROR_NONE+1);  // uncomment for debug
      
      trace(o,2,"<initialized>\n");

      if (params->error != BLE_ERROR_NONE)
      {
         trace(o,0,"error\n");
         if (cbError)
            (*cbError)(o);             // handle error in follow-up
            
         return;
      }

         // Ensure that it is the default instance of BLE
      
      if(o.getInstanceID() != BLE::DEFAULT_INSTANCE)
      {
         return;
      }
    
      (*cbSetup)(o);                   // followup with setup
   }


   void init(O&o, void (*scb)(O&o),void (*ecb)(O&o))   // init BLE system
   {
      cbSetup = scb;                   // store setup callback
      cbError = ecb;                   // store error callback
      o.init(initComplete);
   }


   void init(O&o, void (*scb)(O&o))    // initialize BLE system
   {
      init(o,scb,cbDefaultError);      // continue with default error callback
   }
