// blink.h - blinking sequences for LED1
#ifndef _BLINK_H_
#define _BLINK_H_

#include <mbed.h>
#include "bricks/o.h"

#  define BLINK_SEQUENCE_IDLE         "x       "
#  define BLINK_SEQUENCE_ADVERTISE    "x xxx       "
#  define BLINK_SEQUENCE_CONNECTED    "  xxx       "
#  define BLINK_SEQUENCE_ACTION       "x x x x x       "
#  define BLINK_SEQUENCE_ERROR        "x x x x xxx "
#  define BLINK_SEQUENCE_TRANSITION   "x x x   "

   void morse(const char *pattern, double periode = 0.2);
   void blink(const char *pattern, const char* next, double interval = 0.2);
   void blink(const char *pattern, double periode = 0.2);

   inline void blinkIdle(O&o)          // 'idle' blink sequence
   {
      blink(BLINK_SEQUENCE_IDLE);
   }

   inline void blinkAdvertise(O&o)     // 'advertise' blink sequence
   {
      blink(BLINK_SEQUENCE_ADVERTISE);
   }
   
   inline void blinkConnected(O&o)     // 'connected' blink sequence
   {
      blink(BLINK_SEQUENCE_TRANSITION, BLINK_SEQUENCE_CONNECTED);
   }

   inline void blinkAction(O&o)        // 'action' blink sequence
   {
      blink(BLINK_SEQUENCE_ACTION, BLINK_SEQUENCE_IDLE);
   }

   inline void blinkError(O&o)         // 'error' blink sequence
   {
      blink(BLINK_SEQUENCE_ERROR);
   }

#endif // _BLINK_H_