// blob.h - 'BLOBs' are BLuetooth OBjects
#ifndef _BLOB_H_
#define _BLOB_H_

#include "ble/BLE.h"
#include "ble/Gap.h"

#define _ICCC BLE::InitializationCompleteCallbackContext   // pure short hand
#define _GDCP Gap::DisconnectionCallbackParams_t           // pure short hand
#define _GCCP Gap::ConnectionCallbackParams_t              // pure short hand
#define _GWCP GattWriteCallbackParams                      // pure short hand

   class Blob : public BLE
   {
      public:
         const _ICCC *pComplete;              // params to _ICCC context
         const _GCCP *pConnect;               // params to _GCCP context
         const _GDCP *pDisconnect;            // params to _GDPC context
         const _GWCP *pWritten;               // params to _GWCP context
         
      public: // construction
         Blob() : BLE() // standard constructor
         {
            pComplete = 0;  pDisconnect = 0;
         }
   };


// Setup Advertising Name (syntactic sugar)

   inline void name(Blob &o, const char *str)
   {
      o.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)str, strlen(str)+1);
   }


// Setup Device Name (syntactic sugar)

   inline void device(Blob &o, const char *text)
   {
      o.gap().setDeviceName((const uint8_t *)text);
   }


// Setup Advertising Data (syntactic sugar)

   inline void data(Blob &o, const uint8_t *buf, size_t buflen)
   {
      o.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, buf, buflen);
   }

   inline void data(Blob &o, const char *text)
   {
      size_t len = strlen(text);
      data(o,(const uint8_t*)text,len);
   }
   
#endif // _BLOB_H_