// descriptor.h - a description list, containing a single descriptor
//
// Synopsis:
//
//    Descriptor user(0x2901,"User");
//    Descriptor client(0x2902,"Client");
//
//    UserDescriptor    status("Status");      // user descriptor   0x2901
//    ClientDescriptor  client("Client");      // client descriptor 0x2902
//
#ifndef _DESCRIPTOR_H_
#define _DESCRIPTOR_H_

#include "ble/BLE.h"
#include "ble/Gap.h"

   class Descriptor : public GattAttribute
   {
       private:
          typedef GattAttribute *GattAttributePtr;
       
       public:
          GattAttributePtr plist[1];
          
          Descriptor(UUID uuid, const char *name) :
             GattAttribute(uuid,(uint8_t*)name,strlen(name),strlen(name))
          {
              plist[0] = this;
          }
   };

   class UserDescriptor : public Descriptor
   {
       public:
          UserDescriptor(const char *name) :  Descriptor(0x2901,name)
          {
              // empty
          }
   };

   class ClientDescriptor : public Descriptor
   {
       public:
          ClientDescriptor(const char *name) :  Descriptor(0x2902,name)
          {
              // empty
          }
   };

#endif // _DESCRIPTOR_H_