// init.h - initialize BLE system
//
// Synopsis:
//
//    void init(Blob &o, void (*scb)(Blob&),void (*ecb)(Blob&))  // init BLE
//    void init(Blob &o, void (*scb)(Blob&))                     // init BLE
//
// Arguments:
//
//    o:        Blob object (to avoid name clashes)
//    scb:      setup callback
//    ecb:      error callback
//
// Description:
//
//    Initialize BLE system, providing a setup callback and optionally an error
//    callback. The actual initializing happens in the setup callback. If an
//    error occurs during initializin, the error callback will be consulted. If
//    no error callback is provided an implicit error callback will be called.
//
// Example 1: simple BLE system setup
//
//    void cbSetup(Blob &o)
//    {
//       device(o,"IoT node");         // setup device name
//       name(o,"Node #1");            // setup advertising name
//       advertise("C:ng");            // start advertising
//    }
//
//    main(void)
//    {
//       Blob o;                       // our Blob object
//       init(o,cbSetup);              // init BLE base layer, always do first
//       while (true)                  // Infinite loop waiting for BLE events
//          sleep(o);                  // low energy waiting
//    }
//
// Example 2: Provide also error handler
//
//    void cbError(Blob &o)
//    {
//       trace(0,"init error!");    
//    }
//
//    void cbSetup(Blob &o)
//    {
//       device(o,"IoT node");         // setup device name
//       name(o,"Node #1");            // setup advertising name
//       advertise("C:ng");            // start advertising
//    }
//
//    main(void)
//    {
//       Blob o;                       // our Blob object
//       init(o,cbSetup,cbError);      // init BLE base layer, always do first
//       while (true)                  // Infinite loop waiting for BLE events
//          sleep(o);                  // low energy waiting
//    }
//
// See also: BLOB, INIT
//
#ifndef _INIT_H_
#define _INIT_H_

#include "bricks/o.h"

//==============================================================================
// Initializing
//==============================================================================

   void init(O&o, void (*scb)(O&o),void (*ecb)(O&o));  // init BLE
   void init(O&o, void (*scb)(O&o));                   // init BLE system

#endif // _INIT_H_