// blink.h - blinking sequences for LED1
#ifndef _BLINK_H_
#define _BLINK_H_

#include <mbed.h>
#include "bricks/o.h"

#  define BLINK_SEQUENCE_IDLE         "x       "
#  define BLINK_SEQUENCE_ADVERTISE    "x xxx       "
#  define BLINK_SEQUENCE_CONNECTED    "  xxx       "
#  define BLINK_SEQUENCE_ACTION       "x x x x x       "
#  define BLINK_SEQUENCE_ERROR        "x x x x xxx "
#  define BLINK_SEQUENCE_TRANSITION   "x x x   "

   void morse(O&o,const char *pattern, double periode = 0.2);
   void blink(O&o,const char *pattern, const char* next, double interval = 0.2);
   void blink(O&o,const char *pattern, double periode = 0.2);

   inline void blinkIdle(O&o, const char *action = BLINK_SEQUENCE_IDLE)
   {
      blink(o,action,BLINK_SEQUENCE_IDLE);
   }

   inline void blinkAdvertise(O&o,const char *action = BLINK_SEQUENCE_ADVERTISE)
   {
      blink(o,action,BLINK_SEQUENCE_ADVERTISE);
   }
   
   inline void blinkConnected(O&o, const char *action = BLINK_SEQUENCE_ACTION) 
   {
      blink(o,action, BLINK_SEQUENCE_CONNECTED);  
   }

   inline void blinkAction(O&o)        // 'action' blink sequence
   {
      blink(o,BLINK_SEQUENCE_ACTION, BLINK_SEQUENCE_IDLE);
   }

   inline void blinkError(O&o, const char *action = BLINK_SEQUENCE_ERROR)
   {
      blink(o,action,BLINK_SEQUENCE_ERROR);
   }

   inline void blink(O&o)              // stop blinking
   {
       blink(o,"");                    // empty blinking pattern
   }
   
#endif // _BLINK_H_