// M18_LED_Switch

#include "bricks/bricks.h"

   Service svcLedSwitch(0xFF10,"LED Switch");
   Characteristic<Bool> chrSwitch(svcLedSwitch,0xFF11,"rw","Switch");
   Characteristic<Bool> chrState(svcLedSwitch,0xFF12,"n","State");

   void cbWritten(O&o)                 // data written callback
   {
      Bool value;                      // need some local variables
      
      if (updated(o,chrSwitch))        // changed inputs?
      {
         get(o,chrSwitch,value);       // get value of Input1 characteristics
         set(o,chrState,value);        // store result to Output characteristics
         blink(o,value ? "x" : " ");   // depending on state change blinking
      }
   }
   
//==============================================================================
// BLE Callbacks
//==============================================================================

   void cbError(O&o)                   // Error Reporting Callback
   {
      blinkError(o);                   // indicate advertising
   }    

   void cbConnect(O&o)                 // Connection Callback
   {
      blinkConnected(o,"x x x   ");    // indicate 'just connected'
   }

   void cbDisconnect(O&o)              // Disconnection Callback
   {
      advertise(o);                    // start advertising on client disconnect
      blinkAdvertise(o);               // indicate advertising
   }

   void cbSetup(O&o)
   {
      onConnect(o,cbConnect);          // setup connection callback
      onDisconnect(o,cbDisconnect);    // setup disconnection callback

      enroll(o,svcLedSwitch);          // enroll service functionality
      onWritten(o,cbWritten);          // setup 'data written' callback
   
      device(o,"N18#1.0 LED Switch");  // setup advertising name
      name(o,"LED Switch");            // setup device name
         
      advertise(o,"C:ng",100);         // start advertising @ 100 msec interval
      blinkAdvertise(o);               // show that board is advertising
   }

   main(void)
   {
      O o;                             // Oh ohh - declare a blob (BT OBject)
      blinkIdle(o);                    // idle blinking - just started!

      init(o,cbSetup,cbError);         // init BLE base layer, always do first
      
      while (true)                     // Infinite loop waiting for BLE events
         sleep(o);                     // low power waiting for BLE events 
   }

