// updated.h - check whether a characteristic has been updated
//             note: can only used within 'onWritten' callback
//
// Synopsis:
//
//    See also: CHARACTERISTIC, GET, SET, ONWRITTEN
//
#ifndef _UPDATED_H_
#define _UPDATED_H_

#include "ble/Gap.h"
#include "bricks/blob.h"

   inline int updated(Blob &o,GattCharacteristic &chr)  // has char. been updated?
   {
      const GattWriteCallbackParams *p = o.pWritten;
      if (!p)
         return 0;                               // no update!
      else if(p->handle == chr.getValueHandle())
         return 1;
      else
         return 0;   
   }

#endif // _SET_H_