#include "mbed.h"

Serial pc(USBTX, USBRX);//pcとの通信設定
Serial device(D8,D2);//tx:left  rx:right
DigitalOut REDE(LED1);

void init(void)
{
    device.baud(115200);
    pc.baud(115200);
    device.format(8,Serial::None,1);
    REDE = 0;
}

void getdata()
{
    
}
int read(int ID)
{
        unsigned char CheckSum=0;
        unsigned char get[12]= {0,0,0,0,0,0,0,0,0,0,0,0};
        unsigned char TXdata[8]= {0,0,0,0,0,0,0,0,};
        TXdata[0]=0xFA;
        TXdata[1]=0xAF;
        TXdata[2]=ID;
        TXdata[3]=0x0F;//0f
        TXdata[4]=0x2A;//2a
        TXdata[5]=0x02;//02
        TXdata[6]=0x00;//00
        for(int i=2; i<=6; i++) {
            CheckSum = CheckSum ^ TXdata[i];
            TXdata[7]=CheckSum;
        }
        for (int i=0; i<=7; i++) {
            device.putc(TXdata[i]);
            //pc.putc(TXdata[i]);
         }
        wait_us(100);
        while(get[0] != 0xFD){
            get[0] = device.getc();
        }
            for(int i=1; i<=8; i++) {
                get[i] = device.getc();
              //  pc.putc(get[i]);
            }
        unsigned short deg = 0;
        deg = (get[7]) | ((get[10] << 8));
        if(deg > 0x0600){
             deg = 0xFFFF - deg-1; //値がマイナスの時の対策
             pc.printf("-%d\r\n",deg);
        }
      //  pc.putc((deg >> 8));    //データを上位ビットへ移動
        else pc.printf("%d\r\n",deg);
        
        return 0;
}

void torque(unsigned char ID, unsigned char data)
{

    unsigned char TxData[9]; //bytedata[9byte]
    unsigned char CheckSum = 0; //CheckSum cakcukation

    TxData[0] = 0xFA; //Header
    TxData[1] = 0xAF; //Header
    TxData[2] = ID;   //ID
    TxData[3] = 0x00; //Flags
    TxData[4] = 0x24; //Adress
    TxData[5] = 0x01; //Length
    TxData[6] = 0x01; //Count
    TxData[7] = data; //data

    //CheckSum calculation
    for(int i=2; i<=7; i++) {
        CheckSum = CheckSum ^ TxData[i];
    }
    TxData[8] = CheckSum;

    //Send Packet
    for (int i=0; i<=8; i++) {
        device.putc((char)TxData[i]);
    }
    wait_us(250);
}


int main()
{
    char id = 0x01;
    init();
  //  device.attach(getdata, Serial::RxIrq);
  //  torque(0x01,0x01);
  //  torque(0x02,0x01);
  //  torque(0x03,0x01);
    torque(id,0x00);
    wait(1);
    while(1) {
        read(id);
        REDE = 0;
        wait(0.1);
    }
}