#include "mbed.h"
#include"OUTPUT.h"

Serial device(p9,p10);//tx:left  rx:right
Serial mother(p13,p14);
Serial pc(USBTX,USBRX);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalIn PS(p30);
//DigitalIn
PwmOut motor1_1(p24);
PwmOut motor1_2(p23);
PwmOut motor2_1(p22);
PwmOut motor2_2(p21);

OUTPUT *output = new OUTPUT;
int order = 0;
double motor1_pwm = 0;
double motor2_pwm = 0;


void get_mother(void)
{
    if(mother.getc() == 0xAF) {
        if(mother.getc() == 0xFA) {
            int length = mother.getc();
            int get_data[length];
            for(int i = 3; i < length; i++) get_data[i] = mother.getc();
            order = get_data[3];
            motor1_pwm = get_data[4] - 100;
            motor2_pwm= get_data[5] - 100;

        }
    }
}
void init(void)
{
    device.baud(115200);
    mother.baud(115200);
    mother.attach(&get_mother,Serial::RxIrq);
    pc.baud(115200);
    output->device = &device;
    output->Goal_Position(1,0,0);
   // PS = 0;
    motor1_1.write(0);
    motor1_2.write(0);
    motor2_1.write(0);
    motor2_2.write(0);
}


int main()
{
    init();
    while(1) {
   // PS = 1;
        if(order == 0x01) {
            output->torque(1,0x01);
            output->Goal_Position(1,0,0);
            myled1 = 1;
        } else {
            output->torque(1,0x01);
            myled1 = 0;
        }
        static long int deg = 800;
        static unsigned char deg_8[2] = {(0x00FF & deg),(0x00FF & (deg >> 8))};
        if(order == 0x02) {
            output->Goal_Position(1, deg_8[0], deg_8[1]);
            myled2 = 1;
        }
        else{
            myled2 = 0;
            }
        //motor1_1 = 1;
        //motor2_1 = 1;


        if(motor1_pwm > 0) {
            motor1_1.write(0);
            motor1_2.write(((motor1_pwm) / 100));
            //pc.printf("1\n\r");
            //myled3 = 1;
        } else if(motor1_pwm < 0) {
            //motor1_pwm = -motor1_pwm;
            motor1_1.write((-(motor1_pwm) / 100));
            motor1_2.write(0);
            //pc.printf("2\n\r");
            myled3 = 1;
        } else {
            motor1_1.write(0);
            motor1_2.write(0);
            myled3 = 0;
        }

        if(motor2_pwm > 0) {
            motor2_2.write(0);
            motor2_1.write(((motor2_pwm) / 100));
            //myled4 = 1;
        } else if(motor2_pwm < 0) {
            //motor2_pwm = -motor2_pwm;
            motor2_2.write((-(motor2_pwm) / 100));
            motor2_1.write(0);
            myled4 = 1;
        } else {
            motor2_1.write(0);
            motor2_2.write(0);
            myled4 = 0;
        }
    }
}
