#include "mbed.h"

Serial pc(USBTX, USBRX);//pcとの通信設定
Serial mother(p13,p14);
DigitalOut myled(LED1);

PwmOut fan[4] = {p21,p22,p23,p24};
long int count;
bool   fan_mode[4] = {0,0,0,0};
//double fan_ref[4] = {0.0015,0.0015,0.0015,0.0015};
//double reach_time = 5.0;
/*
PwmOut fan1(p21);
PwmOut fan2(p22);
PwmOut fan3(p23);
PwmOut fan4(p24);
*/
PwmOut servo_slope(p26);
//void fan_accel(PwmOut fan);
unsigned char data;
Ticker FAN_ACCEL;

void fan_accel(void)
{
    static int count[4] = {0,0,0,0};
    for(int i = 0; i <= 3; i++) {
        if(fan_mode[i]) {
            fan[i].pulsewidth(0.0010 + (count[i] * 0.00001));
            pc.printf("%d  %f\n\r",i,(0.0010 + (count[i] * 0.00001)));
            count[i]++;
            if(count[i] >= 50)count[i] = 50;
        } else {
            count[i] = 0;
            fan[i].pulsewidth(0.0010);
        }
    }
}

void get_mother(void)
{
    data = mother.getc();
    myled = !myled;
    count++;
    //pc.printf("%d\n\r",data);
}

void init()
{
    mother.baud(115200);
    pc.baud(115200);
    mother.attach(&get_mother,Serial::RxIrq);
    //FAN_ACCEL.attach(&fan_accel,0.06);
    //ダグデッドファン 1ms~2ms
    for(int i = 0; i <= 3; i++) fan_mode[i] = 0;
    servo_slope.pulsewidth(0.002);//0.7ms~2.3ms//-90~+90
}

int main()
{
    int slope_f = 0;
    init();
    while(1) {
        if(slope_f) {
            if(count > 50) {
                servo_slope.pulsewidth(0.008);//0.7ms~2.3ms//-90~+90
            } else if(count > 0) {
                servo_slope.pulsewidth(0.00072);//0.7ms~2.3ms//-90~+90
            }
            if(count > 100) count = 0;
        }
        switch(data) {
            case 0x0A:
                break;
                /*
                case 0x00://ファン停止
                fan[3].pulsewidth(0.0010);
                //fan_mode[3] = 0;
                break;
                case 0x01://ファン回転
                fan[3].pulsewidth(0.0012);
                //fan_mode[3] = 1;
                break;
                */
            case 0x05://メインファン回転
                fan[0].pulsewidth(0.0015);
                fan[1].pulsewidth(0.0015);
                fan[2].pulsewidth(0.0015);
                /*
                fan_mode[0] = 1;
                fan_mode[1] = 1;
                fan_mode[2] = 1;
                */
                break;
            case 0x04://メインファン停止
                fan[0].pulsewidth(0.0010);
                fan[1].pulsewidth(0.0010);
                fan[2].pulsewidth(0.0010);
                /*
                fan_mode[0] = 0;
                fan_mode[1] = 0;
                fan_mode[2] = 0;
                */
                break;
                
                
            case 0x07://サブファン回転
                fan[0].pulsewidth(0.0015);
                //fan[1].pulsewidth(0.0015);
                //fan[2].pulsewidth(0.0015);
                /*
                fan_mode[0] = 1;
                fan_mode[1] = 1;
                fan_mode[2] = 1;
                */
                break;
            case 0x06://サブ^ファン停止
                fan[0].pulsewidth(0.0010);
                fan[1].pulsewidth(0.0010);
                fan[2].pulsewidth(0.0010);
                /*
                fan_mode[0] = 0;
                fan_mode[1] = 0;
                fan_mode[2] = 0;
                */
                break;
                
            case 0x02://坂下ろし
                servo_slope.pulsewidth(0.002);//0.7ms~2.3ms//-90~+90
                slope_f = 0;
                break;
            case 0x03://坂上げ
                servo_slope.pulsewidth(0.00072);//0.7ms~2.3ms//-90~+90
                slope_f = 1;
                break;

        }
    }
}