#include "mbed.h"
#include "serial.h"

void PC_ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == pc.readable()) {
        inChar = pc.getc();
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagPC_Rx = 1;
            memcpy(PC_rxData, rxBuf, 4);
//            pc.putc(PC_rxData[0]);
//            pc.putc(PC_rxData[1]);
//            pc.putc(PC_rxData[2]);
//            pc.putc(PC_rxData[3]);
 
//            pc.puts(PC_rxData);  
        }
        else {
            rxCount = 0;
            flagPC_Rx = 0;
        }
    }
}

void BT_ReceiveInt() {
    char inChar;
    static char rxCount = 0;
    static char rxBuf[4];
    
    while(1 == bt.readable()) {
        inChar = bt.getc();
//        pc.putc(inChar);
        if ('<' == inChar){
            rxCount = 1;            
        }
        else if (rxCount > 0 && rxCount < 5) {
            rxBuf[rxCount-1] = inChar;
            rxCount++;   
        }
        else if (5 == rxCount && '>' == inChar) {
            rxCount = 0;
            flagBT_Rx = 1;
            memcpy(BT_rxData, rxBuf, 4);
//            bt.putc(BT_rxData[0]);
//            bt.putc(BT_rxData[1]);
//            pbtc.putc(BT_rxData[2]);
//            bt.putc(BT_rxData[3]);
 
//            bt.puts(BT_rxData);  
        }
        else {
            rxCount = 0;
        }
    }
}
