#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library
#include "ADXL345.h"            // ADXL, SPI library
#include "serial.h"             // Serial com. func.

#define NUM_CHAR    16

#define OLED_DISPLAY
#define PWM_TEST

Serial      pc(SERIAL_TX, SERIAL_RX);
Serial      bt(PC_4, PC_5);
DigitalOut  greenLed(LED1);
#ifdef PWM_TEST
PwmOut  redLed(PA_12);
PwmOut  myAnalogOut(PA_4);
#else
DigitalOut  redLed(PA_12);
AnalogOut   myAnalogOut(PA_4);
#endif

Timer       t1, t2; 
Ticker       t3, t4;
InterruptIn   myButton(PC_13);
InterruptIn   exButton(PC_11);

BusOut my7Seg(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB

AnalogIn    lightSensor(PA_0);          
ADXL345     accelerometer(PB_5, PB_4, PB_3, PB_6);       // MOSI, MISO, SCK, CS


char    PC_rxData[5];
char    BT_rxData[5];
bool    flagPC_Rx = 0;
bool    flagBT_Rx = 0;

int     dir = 1;        // 1: increase, -1: decrease
bool    flagT3 = 0;
bool    modeT3 = 0;     // 0: stop, 1: working
bool    flagDAC = 0;
bool    flagADC = 0;    
bool    flagADXL = 0;   // new added

void tickerFunc3() {
    flagT3 = 1;
}

void Btn1Down() {
//    pc.puts("1 pushed\n");   // for debugging
    dir = -1*dir;
}

void Btn1Up() {
//    pc.puts("1 released\n");    // for debugging
#ifndef PWM_OUT    
    greenLed = !greenLed;
#endif
}

void Btn2Down() {
//    pc.puts("2 pushed\n");   // for debugging
    if (1 == modeT3) t3.detach();
    else t3.attach(tickerFunc3, 0.1);
    modeT3 = !modeT3;
}

void Btn2Up() {
//    pc.puts("2 released\n");    // for debugging
#ifndef  PWM_TEST
    redLed = !redLed;
#endif
}

void DACInt() {
    flagDAC = 1;
}

void ADCint() {
    flagADC = 1;
}

// new added
void ADXLInt()
{
    flagADXL = 1;
}

int main()
{   
    pc.baud(115200);
    bt.baud(115200);
 
    pc.attach(&PC_ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    bt.attach(&BT_ReceiveInt, Serial::RxIrq);      // RxIrq, TxIrq
    
    myButton.fall(&Btn1Down);
    myButton.rise(&Btn1Up);
    exButton.fall(&Btn2Down);
    exButton.rise(&Btn2Up);
    
    myButton.disable_irq();     // to avoid unexpected interrupt
    exButton.disable_irq();     // to avoid unexpected interrupt
    
    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
     //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);       // 0b 0000 1011
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
    //Measurement mode.
    accelerometer.setPowerControl(0x08);        // 0b 0000 1000
    
    Ticker  tickerADXL;
//    tickerADXL.attach(&ADXLInt, 0.05);
    

    I2C     I2C_Oled(PB_7, PA_15);       // SDA, SCL
    I2C_Oled.frequency(400000);     // 400kHz clock
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2);    //  reset pin doesn't effect
//    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PD_2, 64, 128);    //  make an error

    myOled.clearDisplay();  // clear buffer     
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.printf("Device ID: 0x%02x\n", accelerometer.getDevId());
    myOled.display();       // show a image on the OLED
    wait(1);

    myButton.enable_irq();     // enable IRQ
    exButton.enable_irq();     // enable IRQ
    
    time_t seconds = time(NULL);
    
    set_time(1617235200);  // Set RTC time to 2021-04-01, 00:00:00
    pc.printf("Time as a basic string = %s", ctime(&seconds));

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
    pc.printf("1) Time as a custom formatted string = %s", buffer);
    strftime(buffer, 32, "%y-%m-%d, %H:%M:%S\n", localtime(&seconds));
    pc.printf("2) Time as a custom formatted string = %s", buffer);    


    pc.puts("\n<< BT_PWM Test Start>>\n");
    pc.printf("ADXL Device ID: 0x%02x\n", accelerometer.getDevId());      // 0xE5
    
    myOled.clearDisplay();  // clear buffer 

    float tempVal = 0;
    char tmpCommand[3];
    int rxVal;
    char    val7Seg[NUM_CHAR] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};

    modeT3 = 1;
    my7Seg = 0xFF;
      
    uint16_t n = 0;
    
    char tempVal2[20] = {0,};
    unsigned int    exLight;
    unsigned char   posY[2] = {0,};
    int     ADXLdata[3];    // new added
//    t3.attach(&tickerFunc3, 0.1);       // ticker3 start for display

#ifdef  PWM_TEST
    redLed.period_ms(20);
    myAnalogOut.period_ms(10);
    myAnalogOut.write(0.5);
#endif

    while(1)
    {
        if (1 == flagT3) {
            flagT3 = 0;
            n = n + dir;
//            if (n > 200) n = 0;
//            myAnalogOut = n*0.005f;
//            sprintf(tempVal2, "%d, %1.2f\n", n, myAnalogOut.read());
//            pc.puts(tempVal2);
            
            my7Seg = ~val7Seg[n%16] & 0x7F;
            
            exLight = lightSensor.read() * 500;     // ADC read & send data : about 300us consume
            sprintf(tempVal2, "%d\n", exLight);
            pc.puts(tempVal2);
            
#ifdef OLED_DISPLAY
            posY[1] = 64 - (unsigned char)((float)(exLight-300) * 0.256f);            // 128/500 = 0.256
            myOled.drawLine(n, posY[0], n+1, posY[1], 1);
            myOled.display();                       // OLED display consumes about 28ms
            posY[0] = posY[1];
            if (n > 127) {
                n = 0;
                myOled.clearDisplay();
            }
#endif
            greenLed = !greenLed;
        }
        
        if (1 == flagADXL) {
            flagADXL = 0;
            accelerometer.getOutput(ADXLdata);      // ADXL reading consumes about 80us
            sprintf(tempVal2, "%d, %d, %d\n", (int16_t)ADXLdata[0], (int16_t)ADXLdata[1], (int16_t)ADXLdata[2]);      // sending data consumes about 1ms (worst case)
            bt.puts(tempVal2);

#ifdef  PWM_TEST
            tempVal = ((int16_t)ADXLdata[0]+100) * 0.01f;
            redLed.write(tempVal);
            if (tempVal < 0.1) tempVal = 0.1;
            myAnalogOut.period_ms((int)(tempVal*10));
//            sprintf(tempVal2,"%d\n", (int)(tempVal*10));
//            pc.puts(tempVal2);
#else
            redLed = !redLed;
#endif
        }
        
        if (1 == flagPC_Rx){
            flagPC_Rx = 0;
            tmpCommand[0] = PC_rxData[0];
            tmpCommand[1] = PC_rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(PC_rxData+2);
            
            if (0 == strcmp(tmpCommand, "LD")) {        // control a LED
                pc.printf("val = %d\n", rxVal);
                greenLed = (1 == rxVal)? 1:0;
            }
            else if (0 == strcmp(tmpCommand, "RE")) {        // reset all variables
       
                greenLed = 0;

#ifndef PWM_TEST
                redLed = 1;
#endif
                n = 0;
            }
            else if (0 == strcmp(tmpCommand, "BT")) {        // check the BT operation
                greenLed = !greenLed;
                pc.puts(">> Sending a data to BT: Hello World!\n");
                bt.puts("Hello World!\n");
            }
            else if (0 == strcmp(tmpCommand, "PW")) {        // check the BT operation
#ifdef  PWM_TEST
                 redLed.period_ms(rxVal);
#endif
            }

       }
       
       if (1 == flagBT_Rx){
            flagBT_Rx = 0;
            pc.puts(">> BT sent data.\n");
            flagBT_Rx = 0;
            tmpCommand[0] = BT_rxData[0];
            tmpCommand[1] = BT_rxData[1];
            tmpCommand[2] = 0;
            rxVal = atoi(BT_rxData+2);
            
           if (0 == strcmp(tmpCommand, "AD")) {        // control ADXL
                if (1 == rxVal) {
                    tickerADXL.attach(&ADXLInt, 0.05);
                    pc.puts(">> Start ADXL operation\n"); 
                }
                else {
                    tickerADXL.detach();
                    pc.puts(">> Stop ADXL operation\n"); 
                }
            }
            else if (0 == strcmp(tmpCommand, "BB")) {        // your command
                // add your code
            }
       }   
    }    
}
