#include "mbed.h"
#include "rtos.h"
#include "I2CMasterRtos.h"
#include "I2CSlaveRtos.h"

const int freq = 400000;
const int adr = 42;
const int len=42;
const char* mstMsg="We are mbed, resistance is futile";
const char* slvMsg="Fine with me, let's get addicted";

static void slvRxMsg(I2CSlaveRtos& slv)
{
    char rxMsg[len];
    memset(rxMsg,0,len);
    if ( slv.receive() == I2CSlave::WriteAddressed) {
        slv.read(rxMsg, len);
        printf("thread %X received message as i2c slave: '%s'\n",Thread::gettid(),rxMsg);
    } else
        printf("Ouch slv rx failure\n");
}

static void slvTxMsg(I2CSlaveRtos& slv)
{
    if ( slv.receive() == I2CSlave::ReadAddressed) {
        slv.write(slvMsg, len);
    } else
        printf("Ouch slv tx failure\n");
}

static void mstTxMsg(I2CMasterRtos& mst)
{
    mst.write(adr,mstMsg,len);
}

static void mstRxMsg(I2CMasterRtos& mst)
{
    char rxMsg[len];
    memset(rxMsg,0,len);
    mst.read(adr,rxMsg,len);
    printf("thread %X received message as i2c master: '%s'\n",Thread::gettid(),rxMsg);
}

static void channel1(void const *args)
{
    I2CMasterRtos mst(p9,p10,freq);
    I2CSlaveRtos slv(p9,p10,freq,adr);
    while(1) {
        slvRxMsg(slv);
        slvTxMsg(slv);
        Thread::wait(100);
        mstTxMsg(mst);
        Thread::wait(100);
        mstRxMsg(mst);
    }
}

void channel2(void const *args)
{
    I2CMasterRtos mst(p28,p27,freq);
    I2CSlaveRtos slv(p28,p27,freq,adr);
    while(1) {
        Thread::wait(100);
        mstTxMsg(mst);
        Thread::wait(100);
        mstRxMsg(mst);
        slvRxMsg(slv);
        slvTxMsg(slv);
    }
}

int doit()
{
    Thread selftalk01(channel1,0,osPriorityAboveNormal);
    Thread selftalk02(channel2,0,osPriorityAboveNormal);

    Thread::wait(10000);

    return 0;
}

