#include "mbed.h"
#include "I2C.h"

int main()
{
    const int len = 128;
    char strs[2][len];

    I2C i2c(p28, p27);
    const uint32_t adr = 0x70<<1;
    char rData[5];
    char wData[5];

    for(int i=0; i<2; i++) {
        // read SW rev from register 0x00 from a srf08 ultra sonic ranger at i2c address 0x70/0xe0
        wData[0] = 0x00; // register address
        int wStat = i2c.write(adr,wData,1,1); // write register address and keep bus open, i.e. don't finish write sequence with an instnt stop condition
        if(i)wait_us(23); // grant some time to the i2c HW to start the unintentional additional write
        rData[0]=0xff;
        int rStat = i2c.read(adr,rData,1); // read srf08's SW rev from register 0x00. If in time, the start condition at the beginning of the sequence would abort the unitended write
        snprintf(strs[i],len,"wStat=0x%02X rStat=0x%02X rData=0x%02X %s\n",wStat,rStat,rData[0], ((wStat|rStat)?"OUCH!":"OK!"));
    }
    printf(strs[0]);
    printf(strs[1]);
    return 0;
}