#ifndef TB6612FNG_H
#define TB6612FNG_H

#include "mbed.h"

/// Simple Interface for Toshiba's TB6612FNG H-Bridge Motor Driver
class TB6612FNG
{
    PwmOut m_pwm;  
    DigitalOut m_ctrl1;
    DigitalOut m_ctrl2;
    int m_pw;  // PWM pulse width setting
    bool m_on; // motor satus
    bool m_brakeOnZeroDC; // behaviour for zero duty cycle
    int m_period;  // PWM period setting

public:
    /** Create TB6612FNG object connected to the specified mbed pins
    * @param pwm PwmOut pin name
    * @param ctrl1/ctrl2 DigitalOut control pin name
    * @param pwmPeriod sets the PWM period (µs)
    * @param brakeOnZeroDC true: The motor brakes on zero pulse width setting. 
    *                      false: The motor output is set to high impedance
    */
    TB6612FNG(PinName pwm, PinName ctrl1, PinName ctrl2, int pwmPeriod=100, bool brakeOnZeroDC=true);
    
    /// Sets the PWM pulse width
    /// @param pw is the PWM pulse width setting in µs.
    /// The sign of the given pulsewidth defines the direction.
    /// With the default PWM period of 100µs (f=10kHz) this value is equivalent to the duty cycle.
    void setPulseWidth(int pw);
    
    /// activates the motor at the duty cycle selected with setPulseWidth()
    void on();
    
    /// deactivates the motor (sets the motor output to high impedance, no short brake)
    void off();
    
    /// brakes the motor by shorting it 
    void brake();
    
    /// set behaviour for zero DC setting
    /// @param brakeOnZeroDC true: The motor brakes on zero pulse width setting. 
    ///                      false: The motor output is set to high impedance
    void setZeroDCReaction(bool brakeOnZeroDC);
    
    /// pulse width assignment
    /// @param pw is the PWM pulse width setting in µs 
    /// @see setPulseWidth(int pw)
    void operator=(int pw) {
        setPulseWidth(pw);
    }
};

#endif
