#include "TB6612FNG.h"

TB6612FNG::TB6612FNG(PinName pwm, PinName ctrl1, PinName ctrl2, int period, bool brakeOnZeroDC)
    :m_pwm(pwm),
     m_ctrl1(ctrl1),
     m_ctrl2(ctrl2),
     m_pw(0),
     m_on(false),
     m_brakeOnZeroDC(brakeOnZeroDC),
     m_period(period)
{
    m_ctrl1 = 0;
    m_ctrl2 = 0;
    m_pwm.period_us(period);
    m_pwm.pulsewidth_us(0);
}

void TB6612FNG::setPulseWidth(int pw)
{
    m_pw=pw;
    if(m_pw>m_period) m_pw=m_period;
    else if(m_pw<-m_period) m_pw=-m_period;

    if(m_on)on();
}

void TB6612FNG::on()
{
    m_on=true;
    if(m_pw>0) {
        m_ctrl1=1;
        m_ctrl2=0;
        m_pwm.pulsewidth_us(m_pw);
    } else if(m_pw<0) {
        m_ctrl1=0;
        m_ctrl2=1;
        m_pwm.pulsewidth_us(-m_pw);
    } else if (m_brakeOnZeroDC) {
        m_pwm.pulsewidth_us(0);
    } else {
        m_ctrl1=0;
        m_ctrl2=0;
    }

}

void TB6612FNG::off()
{
    m_on=false;
    m_ctrl1=0;
    m_ctrl2=0;
}

void TB6612FNG::brake()
{
    m_on=false;
    m_ctrl1=1;
    m_ctrl2=1;
}

void TB6612FNG::setZeroDCReaction(bool brakeOnZeroDC)
{
    m_brakeOnZeroDC=brakeOnZeroDC;
    on();
}