#include "Srf0208IF.h"
#include "I2CMasterRtos.h"
#include "Serial.h"
#include "us_ticker_api.h"
#include "Thread.h"
#include "math.h"

using namespace mbed;
using namespace rtos;

I2CMasterRtos i2c(p28, p27,100000);

Srf08IF srf08(0xe0,i2c);
Srf02IF srf02(0xe6,i2c);

int doit()
{
    Thread::wait(1000);
    printf("\n\n\n########### STARTING ###############\n\n\n");
    Thread::wait(1000);

    if(0) { // reset i3c addresses
        Srf02IF srf(0xe0,i2c);
        srf.resetI2CAdress(0xe6);
        return 0;
    }


    while(1) {
        int t0 = us_ticker_read();
        srf02.triggerEchoMeasurement();
        int t1 = us_ticker_read();
        srf08.triggerRanging();
        //srf08.triggerANNRanging();
        int t2 = us_ticker_read();

        Thread::wait(100);
        //while(!(srf08.rangingCompleted() && srf02.rangingCompleted())) printf(".");
        //while(!(srf02.rangingCompleted())) printf(".");
        //printf("\n");

        int d02=srf02.readDistance_mm();
        int d08=srf08.readDistance_mm();
        srf08.burstRead();


        int l08=srf08.getBrightnessFromRawBuffer();
        const int echos = 5;
        printf("l=%d  d08=%d  d02=%d ",l08,d08,d02);
        for(int i=0; i<echos; ++i) printf("D%d=%d ",i,srf08.getDistanceFromRawBuffer_mm(i));
        //printf("\n");

        int t02a = srf02.readTransitTime_us();
        int t08 = srf08.readTransitTime_us();
        int ok = srf02.triggerRanging();
        Thread::wait(100);
        int t02b = srf02.readTransitTime_us();
        int dmin = srf02.readMinimalDistance_mm();
        int t02c = t02a-(t2-t1);
        printf("      dt08m=%d d02m=%d d02c=%d dt02mc=%d ds0208=%d     dmin=%d\n",
               Srf0208IF::time2dist_us2mm(t08),
               Srf0208IF::time2dist_us2mm(t02b),
               Srf0208IF::time2dist_us2mm(t02c)-130,
               Srf0208IF::time2dist_us2mm(t02b-t02c),
               Srf0208IF::time2dist_us2mm(t08-t02b),
               dmin);
        Thread::wait(100);
        /*
        srf08.triggerANNRanging();
        Thread::wait(100);
        srf08.burstRead();
        printf("d=%d   ",srf08.getDistanceFromRawBuffer_mm(0));
        const int slots=32;
        for(int i=0; i<slots; ++i) printf("%d ",srf08.getANNSlotDataFromRawBuffer(i));
        printf("\n");
        */
        Thread::wait(100);
    }
}