#include "Srf0208IF.h"
#include "Thread.h"
#include "I2CMasterRtos.h"

using namespace mbed;
using namespace rtos; 

bool Srf0208IF::triggerRanging()
{
    const char regNcmd[2]= {0x00,0x52};
    return !m_i2c.write(m_adr, regNcmd, 2);
}
int Srf0208IF::readTransitTime_us()
{
    char result[2];
    bool ok = !m_i2c.read(m_adr, 0x02, result, 2);
    return ok ? twoByte2int(result) : -1;
}
void Srf0208IF::resetI2CAdress(int newAddress)
{
    char regNcmd[2];

    regNcmd[0]=0x00;

    regNcmd[1]=0xA0;
    m_i2c.write(m_adr,regNcmd,2);
    Thread::wait(50);

    regNcmd[1]=0xAA;
    m_i2c.write(m_adr,regNcmd,2);
    Thread::wait(50);

    regNcmd[1]=0xA5;
    m_i2c.write(m_adr,regNcmd,2);
    Thread::wait(50);

    regNcmd[1]=newAddress;
    m_i2c.write(m_adr,regNcmd,2);
    Thread::wait(50);
}
int Srf0208IF::readSWRevision()
{
    char swRev;
    bool ok = !m_i2c.read(m_adr, 0x00, &swRev, 1);
    return ok && swRev!=0xff ? swRev : -1;
}



bool Srf02IF::triggerPing()
{
    const char regNcmd[2]= {0x00,0x5C};
    return !m_i2c.write(m_adr, regNcmd, 2);
}
bool Srf02IF::triggerEchoMeasurement()
{
    const char regNcmd[2]= {0x00,0x58};
    return !m_i2c.write(m_adr, regNcmd, 2);
}
int Srf02IF::readMinimalTransitTime_us()
{
    char result[2];
    bool ok = !m_i2c.read(m_adr, 0x04, result, 2);
    return ok ? twoByte2int(result) : -1;
}



int Srf08IF::readBrightness()
{
    char val;
    bool ok = !m_i2c.read(m_adr, 0x01, &val, 1);
    return ok ? val : -1;
}
bool Srf08IF::triggerANNRanging()
{
    const char regNcmd[2]= {0x00,0x55};
    return !m_i2c.write(m_adr, regNcmd, 2);
}
bool Srf08IF::writeMaxDist(int maxDst)
{
    char regNcmd[2];
    regNcmd[0] = 0x02;
    regNcmd[0] = (char)maxDst;
    return !m_i2c.write(m_adr, regNcmd, 2);
}
bool Srf08IF::writeMaxGain(int maxGain)
{
    char regNcmd[2];
    regNcmd[0] = 0x01;
    regNcmd[0] = (char)maxGain;
    return !m_i2c.write(m_adr, regNcmd, 2);
}
bool Srf08IF::burstRead(int startReg, int stopReg)
{
    if(startReg<0)startReg=0;
    if(stopReg>35)stopReg=35;
    return !m_i2c.read(m_adr, startReg, &(m_rawBuffer[startReg]), stopReg-startReg+1);
}









