#ifndef TIMEOUTTWEAKED_H
#define TIMEOUTTWEAKED_H

#include "Timeout.h"

using namespace mbed; 

/// Tweaked Timeout class, that publishes the protected TimerEvent methods
/// remove() and insert(unsigned int), which are a bit faster than detach() and attach(...).
/// Useful when you just want to restart a timeout in a short ISR, without hooking 
/// in a "new" callback function. Saves ~1.5µs. 
class  TimeoutTweaked : public Timeout {
public:
    /// calls protected TimerEvent::remove()that
    /// just removes the timer event from the schedule but keeps the handler that has been attached before
    inline void remove() {
        TimerEvent::remove();
    }
    /// calls proteccted TimerEvent::insert() that inserts a new timeout event to the schedule at the given timestamp.
    /// e.g. insert(us_ticker_read()+timeout_us)
    inline void insert(unsigned int timestamp) {
        TimerEvent::insert(timestamp);
    }
    /// Attach a function to be called by the tweaked Timeout
    void attach(void (*fptr)(void)) {
        attach_us(fptr, 1e9);
        remove();
    }
    /// Attach a member function to be called by the tweaked Timeout
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void)) {
        attach_us(tptr, mptr, 1e9);
        remove();
    }
};

#endif