
#include "Buffer.h"
#include "Serial.h"
using namespace mbed;

Serial pc(USBTX, USBRX);

const uint32_t maxSize = 5;

typedef Buffer<int,maxSize> TstBufB;
typedef BufferOnStack<int,maxSize> TstBufS;
typedef BufferOnHeap<int,maxSize> TstBufH;

typedef BufferOnHeap<int,maxSize+1> BahBuf;

void chkBuffer(TstBufB& buf);

int doit()
{
    pc.baud(115200);

    TstBufS bufs1;
    TstBufH bufh1;

    /*
    // the following should not even compile
    BahBuf bah;
    bufs1=bah;
    TstBufH no(bah);

    bufs1.push(23);
    const TstBufB& cbuf=bufs1;
    int& e=cbuf[0];

    */

    chkBuffer(bufs1);
    pc.printf("happyhappyjoyjoy 1\n");
    chkBuffer(bufh1);
    pc.printf("happyhappyjoyjoy 2\n");

    // copy ctor and assignment
    TstBufS bufs;
    for(int i=1; i<=23; ++i) bufs.pushCircular(i);
    bufs1=bufs;
    TstBufS bufs2(bufs1);
    bufh1=bufs2;
    TstBufH bufh2(bufh1);
    TstBufS bufs3(bufh2);
    TstBufH bufh3(bufs2);
    TstBufS bufs4;
    TstBufH bufh4;
    bufs4.push(23);
    bufh4.push(42);
    bufs4=bufh3;
    bufh4=bufs3;

    TstBufB* bufA[8];
    bufA[0]=&bufs1;
    bufA[1]=&bufs2;
    bufA[2]=&bufs3;
    bufA[3]=&bufs4;
    bufA[4]=&bufh1;
    bufA[5]=&bufh2;
    bufA[6]=&bufh3;
    bufA[7]=&bufh4;

    for(int i=0; i<maxSize; ++i)
        for(int j=0; j<8; ++j) {
            int v=(*(bufA[j]))[maxSize-1-i];
            if(v!=23-i) pc.printf("copy ouch %d %d %d\n", i,j,v);
        }
    pc.printf("happyhappyjoyjoy 3\n");
    pc.printf("Test ready!\n");

    return 0;
}

void chkBuffer(TstBufB& buf)
{

    buf.clear();
    // empty buffer checks
    if(buf.size()!=0) pc.printf("ouch01\n");
    if(buf.maxSize()!=maxSize) pc.printf("ouch02\n");

    // fill until full
    for(int i=0; i<maxSize; ++i) {
        if(!buf.push(i+1)) pc.printf("ouch03\n");
        if(buf.size()!=i+1) pc.printf("ouch04\n");
    }

    // overfill
    if(buf.push(12)) pc.printf("ouch05\n");
    if(buf.push(13)) pc.printf("ouch05\n");
    if(buf.size()!=maxSize) pc.printf("ouch06\n");

    // content check
    for(int i=0; i<maxSize; ++i)
        if(buf[i]!=i+1)pc.printf("ouch07\n");

    // pops
    if(buf.popLatest()!=maxSize)pc.printf("ouch08\n");
    if(buf.popLatest()!=maxSize-1)pc.printf("ouch09\n");
    if(buf.popOldest()!=1)pc.printf("ouch10\n");
    if(buf.popOldest()!=2)pc.printf("ouch11\n");

    if(buf.size()!=1) pc.printf("ouch12\n");
    if(buf.popLatest()!=maxSize-2)pc.printf("ouch14\n");
    if(buf.popOldest()!=0)pc.printf("ouch15\n");
    if(buf.popLatest()!=0)pc.printf("ouch16\n");
    if(buf.size()!=0) pc.printf("ouch17\n");

    // fill until full
    for(int i=0; i<maxSize; ++i) {
        buf.pushCircular(i+1);
        if(buf.size()!=i+1) pc.printf("ouch19\n");
    }
    // clear check
    buf.clear();
    if(buf.size()!=0) pc.printf("ouch20\n");

    // fill again
    for(int i=0; i<maxSize+1; ++i) {
        buf.pushCircular(i+1);
    }
    if(buf.size()!=maxSize) pc.printf("ouch22\n");

    if(buf.popOldest()!=2)pc.printf("ouch23\n");
    if(buf.popLatest()!=maxSize+1)pc.printf("ouch24\n");
    if(buf.popLatest()!=maxSize)pc.printf("ouch25\n");
    if(buf.popLatest()!=maxSize-1)pc.printf("ouch26\n");

    if(buf.size()!=maxSize-4) pc.printf("ouch27\n");

    // fill revolving
    for(int i=maxSize-1; i<=maxSize+3; ++i) {
        buf.pushCircular(i);
    }

    if(buf.size()!=maxSize) pc.printf("ouch28\n");

    // content check
    for(int i=0; i<maxSize; ++i)
        if(buf[maxSize-i-1]!=maxSize+3-i)pc.printf("ouch29\n");

    // out of bounds
    if(buf[4223]!=0)pc.printf("ouch30\n");
    if(buf[maxSize]!=0)pc.printf("ouch33\n");
    
    // empty/full
    if(!buf.full())pc.printf("ouch34\n");
    if(buf.empty())pc.printf("ouch35\n");
    buf.clear();
    if(buf.full())pc.printf("ouch36\n");
    if(!buf.empty())pc.printf("ouch37\n");
}
