// IT Tralee Mechatronics: Embedded Systems LAB#1
// Revised code to include a simple software solution to mechanical bounce experienced by switch


#include "mbed.h"

InterruptIn d(p12); // down
InterruptIn l(p13); // left
InterruptIn c(p14); // centre
InterruptIn u(p15); // up
InterruptIn r(p16); // right


DigitalOut flash(LED1);
float debounce(0.5); // 0.5s delay: software sln for mechanical bounce 

void left() {
   printf("Left \n \r"); // print
   wait(debounce);  
}

void right() {
    printf("Right \n \r");
    wait(debounce);    
}

void up() {
    printf("Up \n \r");
    wait(debounce);
}

void down() {
    printf("Down \n \r");
    wait(debounce);    
}

void centre() {
    printf("Centre \n \r");
    wait(debounce);
}

int main() {
    l.rise(&left);  // attach the address of the (left in this line) functions to the interrupt rising edge. 0->1
    r.rise(&right);  
    u.rise(&up);
    d.rise(&down);   
    c.rise(&centre);     

    while(1) {           // flash led1 until interrupt to show that program is stopping while interrupt is active. 
        flash = !flash;
        wait(0.2);
    }
}
