#include <mbed.h>
#include <Debouncer.h>
#include <Pulsator.h>
#include <USBKeyboard.h>

// ACTIVE LOW
#define PI_BUTTON P0_1
#define PO_LED P1_15

#define BUTT_DN_KEY '1'
#define BUTT_DN_MOD KEY_CTRL | KEY_ALT
#define BUTT_UP_KEY '1'
#define BUTT_UP_MOD KEY_CTRL | KEY_ALT | KEY_SHIFT

#define LED_PERIOD_DN 0.25f
#define LED_PERIOD_UP 2.0f

static Debouncer butt(PI_BUTTON, PullUp);
static USBKeyboard kbd;
static Pulsator led(PO_LED);

static void butt_fall(void)
{
    kbd.keyCode(BUTT_DN_KEY, BUTT_DN_MOD);
    led.period(LED_PERIOD_DN);
}

static void butt_rise(void)
{
    kbd.keyCode(BUTT_UP_KEY, BUTT_UP_MOD);
    led.period(LED_PERIOD_UP);
}

static float flashing(float x)
{ return x < 0.125f || x >= 0.25f && x < 0.375f ? 1.0f : 0.0f; }

int main(void)
{
    led.active_high(false).fun(&flashing).period(LED_PERIOD_UP) = true;
    while(!kbd.configured()) wait(0.125f);
    led.fun(NULL);
    butt.attach_fall(&butt_fall).attach_rise(&butt_rise);

    while(1) wait(1.0f);
}
