/* Copyright (c) 2015 Liyang HU, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <mbed.h>
#include <PwmOut.h>

class Pulsator : private Ticker
{
private:
    PwmOut out;
    float phase;

    bool _active_high;
    bool _enable;
    float (*_fun)(float phase);
    float _gamma;
    float _period;
    uint16_t _levels;

    void disable(void);
    void enable(void);
    void reload(void);
    void step(void);

public:
    Pulsator(PinName pin = LED1);
    Pulsator& operator=(bool state);
    operator bool(void);

    Pulsator& active_high(bool high = false);
    Pulsator& fun(float (*fp)(float phase) = NULL);
    Pulsator& gamma(float power = 2.2f);
    Pulsator& levels(uint16_t number = 128);
    Pulsator& period(float seconds = 1.0f);
};
