#include "mbed.h"
#include "MODSERIAL.h"
#include "Servo.h"
#include "QEI.h"

QEI encoder_M1 (D9, D10, NC, 8400);     //Define an encoder for motor 1 called encoder_M1
QEI encoder_M2 (D11, D12, NC, 8400);    //Define an encoder for motor 2 called encoder_M2

Ticker encoder_M1_ticker;       //Create a ticker for reading the encoder data of encoder_M1
Ticker encoder_M2_ticker;       //Create a ticker for reading the encoder data of encoder_M2

DigitalOut Direction_M2(D4);    //To control the rotation direction of the arm
PwmOut Speed_M2(D5);            //To control the rotation speed of the arm
PwmOut Speed_M1(D6);            //To control the translation direction of the arm
DigitalOut Direction_M1(D7);    //To control the translation speed of the arm
Servo gripper_servo(D13);       //To control the gripper

InterruptIn Switch_1(SW3);      //Switch 1 to control the rotation to the left
InterruptIn Switch_2(SW2);      //Switch 2 to control the rotation to the right
InterruptIn Switch_3(D2);       //Switch 3 to control the translation of the arm
InterruptIn Switch_4(D3);       //Switch 4 to control the gripper

Ticker      check_goflags_ticker;               //Create a ticker for checking if the go-flags are set true

int counter_rotation_left=0;    //To count the number of times the rotation_left switch (switch_1) has been pushed
int counter_rotation_right=0;   //To count the number of times the rotation_right switch (switch_2) has been pushed
int counter_translation=0;      //To count the number of times the translation switch (switch_3) has been pushed
int counter_gripper=0;          //To count the number of times the gripper switch (switch_4) has been pushed

volatile bool rotation_left_go = false;     //Create a go-flag for the rotation_left and set it to false
volatile bool rotation_right_go = false;    //Create a go-flag for the rotation_right and set it to false
volatile bool translation_go = false;       //Create a go-flag for the translation and set it to false
volatile bool gripper_go = false;           //Create a go-flag for the gripper and set it to false

MODSERIAL pc(USBTX, USBRX);             //Make a connection with the PC

const double pi = 3.1415926535897;      //Declare the value of pi

double speed_rotation=pi/5;             //Set the rotation speed in rad/sec -> NOTE: this has to be below 8.4 rad/sec
double speed_translation=pi/5;          //Set the translation speed in rad/sec -> NOTE: this has to be below 8.4 rad/sec
double speedM1=speed_rotation/8.4;      //Map the rotation speed from (0-8.4) to (0-1) by dividing by 8.4
double speedM2=speed_translation/8.4;   //Map the translation speed from (0-8.4) to (0-1) by dividing by 8.4

float angle_M1=0;       //The measured angle of motor 1 is initially zero
float angle_M2=0;       //The measured angle of motor 2 is initially zero

void read_position_M1(){                            //Function to read the position of motor 1
    int pulses_M1 = -encoder_M1.getPulses();        //Read the encoder data and store it in pulses_M1
    angle_M1 = float(pulses_M1)/4200*2.0*pi;        //Calculate the angle that corresponds with the measured encoder pulses
//    pc.printf("%i \t%f \t", pulses_M1, angle_M1);
}

void read_position_M2(){                            //Function to read the position of motor 2
    int pulses_M2 = -encoder_M2.getPulses();        //Read the encoder data and store it in pulses_M2
    angle_M2 = float(pulses_M2)/4200*2.0*pi;        //Calculate the angle that corresponds with the measured encoder pulses
//    pc.printf("%i \t%f \n", pulses_M2, angle_M2);
}

void activate_rotation_left (){             //To activate the rotation_left
    counter_rotation_left++;                //Increase the counter_rotation_left that counts the number of time switch 1 has been pressed
    if (counter_rotation_left > 2){         //Because there are only 2 cases in the switch statement, case 3 = case 1 etc.
        counter_rotation_left=1;
    }
    rotation_left_go = true;                //After increasing the counter, set the rotation_left go-flag to true
}

void rotation_left (){                      //Function to control the rotation to the left
    switch (counter_rotation_left){         //Create a switch statement
        case 1:                             //For activating the rotation to the left
            Direction_M1 = 1;               //The arm will rotate to the left  
            Speed_M1 = speedM1;             //The motor is turned on at speed_rotation rad/sec
            pc.printf("The arm will now rotate to the left with %f rad/sec \n", speedM1);
            wait(0.1f);
            break;
        case 2:                             //For stopping the rotation to the left
            Direction_M1 = 1;               //The arm will rotate to the left  
            Speed_M1 = 0;                   //The motor is turned off
            pc.printf("The arm will now stop rotating to the left \n");
            wait(0.1f);
            break;
    }
}

void activate_rotation_right (){            //To activate the rotation_right
    counter_rotation_right++;               //Increase the counter_rotation_right that counts the number of time switch 2 has been pressed
    if (counter_rotation_right> 2){         //Because there are only 2 cases in the switch statement, case 3 = case 1
        counter_rotation_right=1;
    }
    rotation_right_go = true;               //After increasing the counter, set the rotation_right go-flag to true
}

void rotation_right (){                     //Function to control the rotation to the left
    switch (counter_rotation_right){        //Create a switch statement
        case 1:                             //For activation the rotation to the right
            Direction_M1 = 0;               //The arm will rotate to the right 
            Speed_M1 = speedM1;             //The motor is turned on at speed_rotation rad/sec
            pc.printf("The arm will now rotate to the right with %f rad/sec \n", speedM1);
            wait(0.1f);
            break;
        case 2:                              //For stopping the rotation to the right
            Direction_M1 = 0;                //The arm will rotate to the right
            Speed_M1 = 0;                    //The motor is turned off
            pc.printf("The arm will now stop rotating to the right \n");
            wait(0.1f);
            break;
    }
}

void activate_translation (){           //To activate the translation
    counter_translation++;              //Increase the counter_translation that counts the number of time switch 3 has been pressed
    if (counter_translation > 4){       //Because there are 4 cases in the switch statement, case 5 = case 1
        counter_translation=1;
    }
    translation_go = true;              //After increasing the counter, set the translation go-flag to true
}

void translation (){                            //Function to control the translation
    switch (counter_translation){               //Create a switch statement
        case 1:                                 //For activating the elongation of the arm
            Direction_M2 = 1;                   //The arm will get longer  
            Speed_M2 = speedM2;                 //The motor is turned on at speed_translation rad/sec
            pc.printf("The arm will now get longer \n");
            wait(0.1f);
            break;
        case 2:                                 //For stopping the elongation of the arm
            Direction_M2 = 1;                   //The arm will get longer  
            Speed_M2 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop getting longer \n");
            wait(0.1f);
            break;
        case 3:                                 //For activating the shortening of the arm
            Direction_M2 = 0;                   //The arm will get shorter  
            Speed_M2 = speedM2;                 //The motor is turned on at speed_translation rad/sec
            pc.printf("The arm will now get shorter \n");
            wait(0.1f);
            break;
        case 4:                                 //For stopping the shortening of the arm
            Direction_M2 = 0;                   //The arm will get shorter 
            Speed_M2 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop getting shorter \n");
            wait(0.1f);
            break;
    }     
}

void activate_gripper (){           //To activate the gripper
    counter_gripper++;              //Increase the couter_gripper that counts the number of time switch 4 has been pressed
    if (counter_gripper> 2){        //Because there are only 2 cases in the switch statement, case 3 = case 1
        counter_gripper=1;
    }
    gripper_go = true;              //After increasing the counter, set the gripper go-flag to true
}

void gripper (){                        //Function to control the gripper
    switch (counter_gripper){           //Create a switch statement
        case 1:                         //For closing the gripper
            gripper_servo = 0;          //The gripper is now closed
            pc.printf("The gripper will now close \n");
            wait(0.1f);
            break;
        case 2:                         //For opening the gripper
            gripper_servo = 0.3;        //The gripper is now open
            pc.printf("The gripper will now open \n");
            wait(0.1f);
            break;
    }     
}

void check_goflags (){          //Function to check if the go-flags are activated
    if (rotation_left_go == true) {     //If the rotation_left go-flag is true
        rotation_left_go = false;       //Set the rotation_left go-flag to false
        rotation_left();                //Execute the rotation_left function
    }
    if (rotation_right_go == true) {    //If the rotation_right go-flag is true
        rotation_right_go = false;      //Set the rotation_right go-flag to false
        rotation_right();               //Execute the rotation_right function
    }
    if (translation_go == true) {       //If the translation go-flag is true
        translation_go = false;         //Set the translation go-flag to false
        translation();                  //Execute the translation function
    }
    if (gripper_go == true) {           //If the gripper go-flag is true
        gripper_go = false;             //Set the gripper go-flag to false
        gripper();                      //Execute the gripper function
    }  
}

int main(){
    pc.baud(115200);                //Set the boud rate for serial communication
    pc.printf("RESET \n");          //Print "RESET"
    
    Direction_M1 = 1;               //The arm will initially get longer  
    Speed_M1 = 0;                   //The first motor is initially turned off
    Direction_M2 = 255;             //The arm will initially turn left  
    Speed_M2 = 0;                   //The second motor is initially turned off
    gripper_servo = 0.3;            //The gripper is initially open
    encoder_M1.reset();             //Reset the encoder for motor 1
    encoder_M2.reset();             //Reset the encoder for motor 2
    
    encoder_M1_ticker.attach(&read_position_M1,0.01);   //Connect the encoder_M1_ticker to the read_position_M1 function and execute at 100Hz
    encoder_M2_ticker.attach(&read_position_M2,0.01);   //Connect the encoder_M2_ticker to the read_position_M2 function and execute at 100Hz
    
    Switch_1.rise(&activate_rotation_left);             //Use switch_1 to activate the counter_rotation_left go-flag
    Switch_2.rise(&activate_rotation_right);            //Use switch_2 to activate the counter_rotation_right go-flag
    Switch_3.rise(&activate_translation);               //Use switch_3 to activate the counter_translation go-flag
    Switch_4.rise(&activate_gripper);                   //Use switch_4 to activate the counter_gripper go-flag

    check_goflags_ticker.attach(&check_goflags, 0.01);         //Connect the check_goflags_ticker to the check_goflags
    
    while (true){}
}