#include "mbed.h"           //Include the mbed library
#include "MODSERIAL.h"      //Include the MODSERIAL library for communication with the pc
#include "Servo.h"          //Include the Servo library for controlling the gripper
#include "QEI.h"            //Include the QEI library for reading the encoder data of the DC-motors
//#include "HIDScope.h"       //Include the HIDScope library for plotting the emg data
#include "BiQuad.h"         //Include the BiQuad library for filtering the emg signal

MODSERIAL   pc(USBTX, USBRX);           //Make a connection with the PC
//HIDScope    scope(4);                   //Create a 4-channel HIDScope object

const double pi = 3.1415926535897;      //Declare the value of pi

double speed_rotation=pi/5;             //Set the rotation speed in rad/sec -> NOTE: this has to be below 8.4 rad/sec
double speed_translation=pi/5;          //Set the translation speed in rad/sec -> NOTE: this has to be below 8.4 rad/sec
double speedM1=speed_rotation/8.4;      //Map the rotation speed from (0-8.4) to (0-1) by dividing by 8.4
double speedM2=speed_translation/8.4;   //Map the translation speed from (0-8.4) to (0-1) by dividing by 8.4

QEI encoder_M1 (D9, D10, NC, 8400);     //Define an encoder for motor 1 called encoder_M1
QEI encoder_M2 (D11, D12, NC, 8400);    //Define an encoder for motor 2 called encoder_M2

Ticker encoder_M1_ticker;       //Create a ticker for reading the encoder data of encoder_M1
Ticker encoder_M2_ticker;       //Create a ticker for reading the encoder data of encoder_M2

DigitalOut Direction_M2(D4);    //To control the rotation direction of the arm
PwmOut Speed_M2(D5);            //To control the rotation speed of the arm
PwmOut Speed_M1(D6);            //To control the translation direction of the arm
DigitalOut Direction_M1(D7);    //To control the translation speed of the arm
Servo gripper_servo(D13);       //To control the gripper

InterruptIn Switch_1(SW3);      //Switch 1 to control the rotation to the left
InterruptIn Switch_2(SW2);      //Switch 2 to control the rotation to the right
InterruptIn Switch_3(D2);       //Switch 3 to control the translation of the arm
InterruptIn Switch_4(D3);       //Switch 4 to control the gripper

DigitalOut  red(LED_RED);       //LED for calibration_biceps (red)
DigitalOut  blue(LED_BLUE);     //LED for calibration_triceps (blue)

AnalogIn    emg_1(A0);          //Analog of EMG 1    
AnalogIn    emg_2(A1);          //Analog of EMG 2
AnalogIn    emg_3(A2);          //Analog of EMG 3
//AnalogIn    emg_4(A3);          //Analog of EMG 4

double emg_1_value = 0;         //Initially the emg_1 value is zero
double emg_2_value = 0;         //Initially the emg_2 value is zero
double emg_3_value = 0;         //Initially the emg_3 value is zero
double emg_4_value = 0;         //Initially the emg_4 value is zero

double signalpart1=0;           //Initially signalpart1 is zero 
double signalpart2=0;           //Initially signalpart2 is zero 
double signalpart3=0;           //Initially signalpart3 is zero 
double signalpart4=0;           //Initially signalpart4 is zero 
double emg_1_filtered = 0;      //Initially the emg_1_filtered signal is zero
double emg_2_filtered = 0;      //Initially the emg_2_filtered signal is zero
double emg_3_filtered = 0;      //Initially the emg_3_filtered signal is zero
double emg_4_filtered = 0;      //Initially the emg_4_filtered signal is zero
double maximum_calibration_value_1=0;           //Initially the maximum calibration value for emg 1 is zero
double maximum_calibration_value_2=0;           //Initially the maximum calibration value for emg 2 is zero
double maximum_calibration_value_3=0;           //Initially the maximum calibration value for emg 3 is zero
double maximum_calibration_value_4=0;           //Initially the maximum calibration value for emg 4 is zero
bool calibration_biceps_done=0;                 //Initially the biceps calibration is not done
bool calibration_triceps_done=0;                //Initially the tricpes calibration is not done

volatile double emg_1_threshold = 0.2;          //Set the threshold for emg 1
volatile double emg_2_threshold = 0.2;          //Set the threshold for emg 2
volatile double emg_3_threshold = 0.2;          //Set the threshold for emg 3
volatile double emg_4_threshold = 0.2;          //Set the threshold for emg 4

Ticker      filter_EMG_ticker;                          //Create a ticker for the filtering of all emg signals
Ticker      calibration_biceps_ticker;                  //Create a ticker for the biceps calibration
Ticker      calibration_triceps_ticker;                 //Create a ticker for the triceps calibration
Ticker      check_threshold_crossing_ticker;            //Create a ticker for checking if the threshold is crossed
Ticker      check_goflags_ticker;                       //Create a ticker for checking if the go-flags are set true

//Create Biquad filters for the filtering of emg_1
BiQuad highpass1(0.9565, -1.9131, 0.9565, -1.9112, 0.9150);             //Create a highpass filter to remove low-frequent noise
BiQuad notch1(0.9938, -1.8902, 0.9938, -1.8902, 0.9875);                //Create a notch-filter to remove 50Hz noise
BiQuad lowpass1(0.00003913, 0.00007826, 0.00003913, -1.9822, 0.9824);   //Create a lowpass filter to envelope the signal

//Create Biquad filters for the filtering of emg_2
BiQuad highpass2(0.9565, -1.9131, 0.9565, -1.9112, 0.9150);             //Create a highpass filter to remove low-frequent noise
BiQuad notch2(0.9938, -1.8902, 0.9938, -1.8902, 0.9875);                //Create a notch-filter to remove 50Hz noise
BiQuad lowpass2(0.00003913, 0.00007826, 0.00003913, -1.9822, 0.9824);   //Create a lowpass filter to envelope the signal

//Create Biquad filters for the filtering of emg_3
BiQuad highpass3(0.9565, -1.9131, 0.9565, -1.9112, 0.9150);             //Create a highpass filter to remove low-frequent noise
BiQuad notch3(0.9938, -1.8902, 0.9938, -1.8902, 0.9875);                //Create a notch-filter to remove 50Hz noise
BiQuad lowpass3(0.00003913, 0.00007826, 0.00003913, -1.9822, 0.9824);   //Create a lowpass filter to envelope the signal

////Create Biquad filters for the filtering of emg_4
//BiQuad highpass4(0.9565, -1.9131, 0.9565, -1.9112, 0.9150);             //Create a highpass filter to remove low-frequent noise
//BiQuad notch4(0.9938, -1.8902, 0.9938, -1.8902, 0.9875);                //Create a notch-filter to remove 50Hz noise
//BiQuad lowpass4(0.00003913, 0.00007826, 0.00003913, -1.9822, 0.9824);   //Create a lowpass filter to envelope the signal

int counter_rotation_left=0;    //To count the number of times the rotation_left switch (switch_1) has been pushed
int counter_rotation_right=0;   //To count the number of times the rotation_right switch (switch_2) has been pushed
int counter_translation=0;      //To count the number of times the translation switch (switch_3) has been pushed
int counter_gripper=0;          //To count the number of times the gripper switch (switch_4) has been pushed

bool emg_1_activated = 0;   //Initially the emg_1 has not crossed the threshold
bool emg_2_activated = 0;   //Initially the emg_2 has not crossed the threshold
bool emg_3_activated = 0;   //Initially the emg_3 has not crossed the threshold
bool emg_4_activated = 0;   //Initially the emg_4 has not crossed the threshold

volatile bool rotation_left_go = 0;     //Create a go-flag for the rotation_left and set it to false
volatile bool rotation_right_go = 0;    //Create a go-flag for the rotation_right and set it to false
volatile bool translation_go = 0;       //Create a go-flag for the translation and set it to false
volatile bool gripper_go = 0;           //Create a go-flag for the gripper and set it to false

float angle_M1=0;       //The measured angle of motor 1 is initially zero
float angle_M2=0;       //The measured angle of motor 2 is initially zero

void read_position_M1 (){                           //Function to read the position of motor 1
    int pulses_M1 = -encoder_M1.getPulses();        //Read the encoder data and store it in pulses_M1
    angle_M1 = float(pulses_M1)/4200*2.0*pi;        //Calculate the angle that corresponds with the measured encoder pulses
//    pc.printf("%i \t%f \t", pulses_M1, angle_M1);
}

void read_position_M2 (){                           //Function to read the position of motor 2
    int pulses_M2 = -encoder_M2.getPulses();        //Read the encoder data and store it in pulses_M2
    angle_M2 = float(pulses_M2)/4200*2.0*pi;        //Calculate the angle that corresponds with the measured encoder pulses
//    pc.printf("%i \t%f \n", pulses_M2, angle_M2);
}

void activate_rotation_left (){                 //To activate the rotation_left
    counter_rotation_left++;                    //Increase the counter_rotation_left that counts the number of time switch 1 has been pressed
    if (counter_rotation_left > 2){             //Because there are only 2 cases in the switch statement, case 3 = case 1 etc.
        counter_rotation_left=1;
    }
    rotation_left_go = 1;                       //After increasing the counter, set the rotation_left go-flag to true
}

void rotation_left (){                          //Function to control the rotation to the left
    switch (counter_rotation_left){             //Create a switch statement
        case 1:                                 //For activating the rotation to the left
            Direction_M1 = 1;                   //The arm will rotate to the left  
            Speed_M1 = speedM1;                 //The motor is turned on at speed_rotation rad/sec
            pc.printf("The arm will now rotate to the left with %f rad/sec \n", speedM1);
            wait(0.1f);
            break;
        case 2:                                 //For stopping the rotation to the left
            Direction_M1 = 1;                   //The arm will rotate to the left  
            Speed_M1 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop rotating to the left \n");
            wait(0.1f);
            break;
    }
}

void activate_rotation_right (){                //To activate the rotation_right
    counter_rotation_right++;                   //Increase the counter_rotation_right that counts the number of time switch 2 has been pressed
    if (counter_rotation_right> 2){             //Because there are only 2 cases in the switch statement, case 3 = case 1
        counter_rotation_right=1;
    }
    rotation_right_go = 1;                      //After increasing the counter, set the rotation_right go-flag to true
}

void rotation_right (){                         //Function to control the rotation to the left
    switch (counter_rotation_right){            //Create a switch statement
        case 1:                                 //For activation the rotation to the right
            Direction_M1 = 0;                   //The arm will rotate to the right 
            Speed_M1 = speedM1;                 //The motor is turned on at speed_rotation rad/sec
            pc.printf("The arm will now rotate to the right with %f rad/sec \n", speedM1);
            wait(0.1f);
            break;
        case 2:                                 //For stopping the rotation to the right
            Direction_M1 = 0;                   //The arm will rotate to the right
            Speed_M1 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop rotating to the right \n");
            wait(0.1f);
            break;
    }
}

void activate_translation (){                   //To activate the translation
    counter_translation++;                      //Increase the counter_translation that counts the number of time switch 3 has been pressed
    if (counter_translation > 4){               //Because there are 4 cases in the switch statement, case 5 = case 1
        counter_translation=1;
    }
    translation_go = 1;                         //After increasing the counter, set the translation go-flag to true
}

void translation (){                            //Function to control the translation
    switch (counter_translation){               //Create a switch statement
        case 1:                                 //For activating the elongation of the arm
            Direction_M2 = 1;                   //The arm will get longer  
            Speed_M2 = speedM2;                 //The motor is turned on at speed_translation rad/sec
            pc.printf("The arm will now get longer \n");
            wait(0.1f);
            break;
        case 2:                                 //For stopping the elongation of the arm
            Direction_M2 = 1;                   //The arm will get longer  
            Speed_M2 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop getting longer \n");
            wait(0.1f);
            break;
        case 3:                                 //For activating the shortening of the arm
            Direction_M2 = 0;                   //The arm will get shorter  
            Speed_M2 = speedM2;                 //The motor is turned on at speed_translation rad/sec
            pc.printf("The arm will now get shorter \n");
            wait(0.1f);
            break;
        case 4:                                 //For stopping the shortening of the arm
            Direction_M2 = 0;                   //The arm will get shorter 
            Speed_M2 = 0;                       //The motor is turned off
            pc.printf("The arm will now stop getting shorter \n");
            wait(0.1f);
            break;
    }     
}

void activate_gripper (){                       //To activate the gripper
    counter_gripper++;                          //Increase the couter_gripper that counts the number of time switch 4 has been pressed
    if (counter_gripper> 2){                    //Because there are only 2 cases in the switch statement, case 3 = case 1
        counter_gripper=1;
    }
    gripper_go = 1;                             //After increasing the counter, set the gripper go-flag to true
}

void gripper (){                                //Function to control the gripper
    switch (counter_gripper){                   //Create a switch statement
        case 1:                                 //For closing the gripper
            gripper_servo = 0;                  //The gripper is now closed
            pc.printf("The gripper will now close \n");
            wait(0.1f);
            break;
        case 2:                                 //For opening the gripper
            gripper_servo = 0.3;                //The gripper is now open
            pc.printf("The gripper will now open \n");
            wait(0.1f);
            break;
    }     
}

void calibration_biceps(){                                          //Function to calibrate the biceps
    if(Switch_1.read()== 0) {                                       //If Switch_1 is pressed
        for(int n=0; n<3000; n++){                                  //For 3000 samples
            signalpart1 = highpass1.step(emg_1.read());             //Filter the signal with the highpass filter
            signalpart2 = notch1.step(signalpart1);                 //Filter the signal with the notch filter
            signalpart3 = fabs(signalpart2);                        //Rectify the signal
            emg_1_filtered = lowpass1.step(signalpart3);            //Filter the signal with the lowpass filter
            if (emg_1_filtered > maximum_calibration_value_1) {     //If the measured value is higher than the maximum value
                maximum_calibration_value_1 = emg_1_filtered;       //The measured value is the new maximum value
            }
            emg_1_threshold = maximum_calibration_value_1*0.7;      //Set the threshold for emg 1
            
            signalpart1 = highpass2.step(emg_2.read());             //Filter the signal with the highpass filter
            signalpart2 = notch2.step(signalpart1);                 //Filter the signal with the notch filter
            signalpart3 = fabs(signalpart2);                        //Rectify the signal
            emg_2_filtered = lowpass2.step(signalpart3);            //Filter the signal with the lowpass filter
            if (emg_2_filtered > maximum_calibration_value_2) {     //If the measured value is higher than the maximum value
                maximum_calibration_value_2 = emg_2_filtered;       //The measured value is the new maximum value
            }
            emg_2_threshold = maximum_calibration_value_2*0.7;      //Set the threshold for emg 2
        }
        
        red = 0;                                                    //Switch the red light on to indicate the biceps calibration is done
        calibration_biceps_done=1;                                  //Declare that the biceps calibration is done
    }   
}

void calibration_triceps(){                                         //Function to calibrate the triceps
    if(Switch_2.read()== 0) {                                       //If Switch_2 is pressed
        for(int n=0; n<3000; n++){                                  //For 3000 samples
            signalpart1 = highpass3.step(emg_3.read());             //Filter the signal with the highpass filter
            signalpart2 = notch3.step(signalpart1);                 //Filter the signal with the notch filter
            signalpart3 = fabs(signalpart2);                        //Rectify the signal
            emg_3_filtered = lowpass3.step(signalpart3);            //Filter the signal with the lowpass filter
            if (emg_3_filtered > maximum_calibration_value_3) {     //If the measured value is higher than the maximum value
                maximum_calibration_value_3 = emg_3_filtered;       //The measured value is the new maximum value
            }
            emg_3_threshold = maximum_calibration_value_3*0.4;      //Set the threshold for emg 3
            
//            signalpart1 = highpass4.step(emg_4.read());             //Filter the signal with the highpass filter
//            signalpart2 = notch4.step(signalpart1);                 //Filter the signal with the notch filter
//            signalpart3 = fabs(signalpart2);                        //Rectify the signal
//            emg_4_filtered = lowpass4.step(signalpart3);            //Filter the signal with the lowpass filter
//            if (emg_4_filtered > maximum_calibration_value_4) {     //If the measured value is higher than the maximum value
//                maximum_calibration_value_4 = emg_4_filtered;       //The measured value is the new maximum value
//            }
//            emg_4_threshold = maximum_calibration_value_4*0.4;      //Set the threshold for emg 4
        }
        
        blue = 0;                                                   //Switch the blue light on to indicate the triceps calibration is done
        calibration_triceps_done=1;                                 //Declare that the triceps calibration is done
    }   
}

void filter_emg(){                                                      //Function to filter the emg signals
    if(calibration_biceps_done==1 && calibration_triceps_done==1) {     //If both calibrations are done
        signalpart1 = highpass1.step(emg_1.read());                     //Filter the signal with the highpass filter
        signalpart2 = notch1.step(signalpart1);                         //Filter the signal with the notch filter
        signalpart3 = fabs(signalpart2);                                //Rectify the signal
        emg_1_filtered = lowpass1.step(signalpart3);                    //Filter the signal with the lowpass filter
//        pc.printf("%f \n", emg_1_filtered);  
  
        signalpart1 = highpass2.step(emg_2.read());                     //Filter the signal with the highpass filter
        signalpart2 = notch2.step(signalpart1);                         //Filter the signal with the notch filter
        signalpart3 = fabs(signalpart2);                                //Rectify the signal
        emg_2_filtered = lowpass2.step(signalpart3);                    //Filter the signal with the lowpass filter
//        pc.printf("%f \n", emg_2_filtered);  

        signalpart1 = highpass3.step(emg_1.read());                     //Filter the signal with the highpass filter
        signalpart2 = notch3.step(signalpart1);                         //Filter the signal with the notch filter
        signalpart3 = fabs(signalpart2);                                //Rectify the signal
        emg_3_filtered = lowpass3.step(signalpart3);                    //Filter the signal with the lowpass filter
//        pc.printf("%f \n", emg_3_filtered);  
        
//        signalpart1 = highpass4.step(emg_1.read());                     //Filter the signal with the highpass filter
//        signalpart2 = notch_low4.step(signalpart1);                     //Filter the signal with the notch filter
//        signalpart3 = fabs(signalpart2);                                //Rectify the signal
//        emg_4_filtered = lowpass4.step(signalpart3);                    //Filter the signal with the lowpass filter
////        pc.printf("%f \n", emg_4_filtered);  
        
//        scope.set(0,emg_1_filtered);          //Plot the emg_1_filtered in the first scope of HIDScope
//        scope.set(1,emg_2_filtered);          //Plot the emg_2_filtered in the second scope of HIDScope
//        scope.set(2,emg_3_filtered);          //Plot the emg_3_filtered in the third scope of HIDScope
//        scope.set(3,emg_4_filtered);          //Plot the emg_4_filtered in the fourth scope of HIDScope
//        scope.send();                         //Send all the data to HIDScope
    }
}

void check_threshold_crossing (){               //Function to check if the emg thresholds are crossed
    if(calibration_biceps_done==1 && calibration_triceps_done==1) {       //If both calibrations are done
        if(emg_1_filtered >= emg_1_threshold && emg_1_activated == 0) {                 //If the filtered emg 1 signal is above the threshold value and if emg_1 is not activated yet 
            emg_1_activated = 1;                                                        //Declare that emg_1 is activated
            activate_rotation_left();                                                   //Execute the activate_rotation_left function
            wait(0.1f);
        } else if (emg_1_filtered <= emg_1_threshold) {                                 //If the filtered emg 1 signal is below the threshold value
            emg_1_activated = 0;                                                        //Declare that emg_1 is deactivated
        }
        if(emg_2_filtered >= emg_2_threshold && emg_2_activated == 0) {                 //If the filtered emg 2 signal is above the threshold value and if emg_2 is not activated yet 
            emg_2_activated = 1;                                                        //Declare that emg_2 is activated
            activate_rotation_right();                                                  //Execute the activate_rotation_right function
            wait(0.1f);
        } else if (emg_2_filtered <= emg_2_threshold) {                                 //If the filtered emg 2 signal is below the threshold value
            emg_2_activated = 0;                                                        //Declare that emg_2 is deactivated
        }
        if(emg_3_filtered >= emg_3_threshold && emg_3_activated == 0) {                 //If the filtered emg 3 signal is above the threshold value and if emg_3 is not activated yet 
            emg_3_activated = 1;                                                        //Declare that emg_3 is activated
            activate_translation();                                                     //Execute the activate_translation function
            wait(0.1f);
        } else if (emg_3_filtered <= emg_3_threshold) {                                 //If the filtered emg 3 signal is below the threshold value
            emg_3_activated = 0;                                                        //Declare that emg_3 is deactivated
        }
//        if(emg_4_filtered >= emg_4_threshold && emg_4_activated == 0) {                 //If the filtered emg 4 signal is above the threshold value and if emg_4 is not activated yet 
//            emg_4_activated = 1;                                                        //Declare that emg_4 is activated
//            activate_gripper();                                                         //Execute the activate_gripper function
//            wait(0.1f);
//        } else if (emg_4_filtered <= emg_4_threshold) {                                 //If the filtered emg 4 signal is below the threshold value
//            emg_4_activated = 0;                                                        //Declare that emg_4 is deactivated
//        }
    }
}

void check_goflags (){              //Function to check if the go-flags are activated
    if (rotation_left_go == 1) {    //If the rotation_left go-flag is true
        rotation_left_go = 0;       //Set the rotation_left go-flag to false
        rotation_left();            //Execute the rotation_left function
    }
    if (rotation_right_go == 1) {   //If the rotation_right go-flag is true
        rotation_right_go = 0;      //Set the rotation_right go-flag to false
        rotation_right();           //Execute the rotation_right function
    }
    if (translation_go == 1) {      //If the translation go-flag is true
        translation_go = 0;         //Set the translation go-flag to false
        translation();              //Execute the translation function
    }
    if (gripper_go == 1) {          //If the gripper go-flag is true
        gripper_go = 0;             //Set the gripper go-flag to false
        gripper();                  //Execute the gripper function
    }  
}

int main (){
    pc.baud(115200);                //Set the boud rate for serial communication
    pc.printf("RESET \n");          //Print "RESET"
    
    red=1;                          //The red LED will initially be switched off
    blue=1;                         //The blue LED will initially be switched off
    Direction_M1 = 1;               //The arm will initially get longer  
    Speed_M1 = 0;                   //The first motor is initially turned off
    Direction_M2 = 1;               //The arm will initially turn left  
    Speed_M2 = 0;                   //The second motor is initially turned off
    gripper_servo = 0.3;            //The gripper is initially open
    encoder_M1.reset();             //Reset the encoder for motor 1
    encoder_M2.reset();             //Reset the encoder for motor 2
    
    encoder_M1_ticker.attach(&read_position_M1,0.01);   //Connect the encoder_M1_ticker to the read_position_M1 function and execute at 100Hz
    encoder_M2_ticker.attach(&read_position_M2,0.01);   //Connect the encoder_M2_ticker to the read_position_M2 function and execute at 100Hz
    
//    Switch_1.rise(&activate_rotation_left);             //Use switch_1 to activate the counter_rotation_left go-flag
//    Switch_2.rise(&activate_rotation_right);            //Use switch_2 to activate the counter_rotation_right go-flag
//    Switch_3.rise(&activate_translation);               //Use switch_3 to activate the counter_translation go-flag
//    Switch_4.rise(&activate_gripper);                   //Use switch_4 to activate the counter_gripper go-flag

    filter_EMG_ticker.attach(&filter_emg, 0.001);                               //Connect the filter_EMG_ticker to the filter_EMG funtion and execute at 1000Hz
    calibration_biceps_ticker.attach(&calibration_biceps, 0.001);               //Connect the calibration_biceps_ticker to the calibration_biceps function and execute at 1000Hz
    calibration_triceps_ticker.attach(&calibration_triceps, 0.001);             //Connect the calibration_triceps_ticker to the calibration_triceps function and execute at 1000Hz
    check_threshold_crossing_ticker.attach(&check_threshold_crossing, 0.01);    //Connect the check_threshold_crossing_ticker to the check_threshold_crossing function and execute at 100Hz
    check_goflags_ticker.attach(&check_goflags, 0.01);                          //Connect the check_goflags_ticker to the check_goflags and execute at 100Hz
    
    while (1){}      //Create a while loop to let the main loop run indefinitly
}