#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h"        // Require the HIDScope library
#include "MODSERIAL.h"

//Define objects
AnalogIn    emg(A0); //Analog of EMG input
Ticker      sample_timer;
Ticker      motor_timer;
Ticker      cal_timer;
HIDScope    scope(2);        // Instantize a 2-channel HIDScope object
DigitalIn   button1(PTA4);//test button for starting motor 1
DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_BLUE);
MODSERIAL   pc(USBTX,USBRX);

/*The biquad filters required to transform the EMG signal into an usable signal*/
biquadFilter filterhigh1(-1.1430, 0.4128, 0.6389, -1.2779, 0.6389);
biquadFilter filterlow1(1.9556, 0.9565, 0.9780, 1.9561, 0.9780);
biquadFilter notch(-1.1978e-16, 0.9561, 0.9780, -1.1978e-16, 0.9780);
biquadFilter filterlow2(-1.9645, 0.9651, 1.5515e-4, 3.1030e-4, 1.5515e-4);
double emg_value;
double signalpart1;
double signalpart2;
double signalpart3;
double signalpart4;
double signalfinal;
double onoffsignal;
double maxcal=0;        
bool calyes=0;

/* 
 */
void filter(){
        if(calyes==1){
        emg_value = emg.read();//read the emg value from the elektrodes
        signalpart1 = notch.step(emg_value);//Highpass filter for removing offset and artifacts
        signalpart2 = filterhigh1.step(signalpart1);//rectify the filtered signal
        signalpart3 = abs(signalpart2);//low pass filter to envelope the emg
        signalpart4 = filterlow1.step(signalpart3);//notch filter to remove 50Hz signal
        signalfinal = filterlow2.step(signalpart4);//2nd low pass filter to envelope the emg
        onoffsignal=signalfinal/maxcal;//divide the emg signal by the max EMG to calibrate the signal per person
        scope.set(0,emg_value);//set emg signal to scope in channel 1
        scope.set(1,onoffsignal);//set filtered signal to scope in channel 2
        scope.send();//send the signals to the scope
        //pc.printf("emg signal %f, filtered signal %f \n",emg_value,onoffsignal);
}
}
void checkmotor(){//check the normalized signal and set actions if a threshold is passed
    if(calyes==1){
    if(onoffsignal<=0.25){
             led1.write(1);
             led2.write(0);
             }
    else if(onoffsignal >= 0.5){
                 led1.write(0);
                 led2.write(1);
             }
             }
}

void calibri(){//calibration function
    if(button1.read()==false){
        for(int n =0; n<5000;n++){//read for 5000 samples as calibration
            emg_value = emg.read();//read the emg value from the elektrodes
            signalpart1 = notch.step(emg_value);//Highpass filter for removing offset and artifacts
            signalpart2 = filterhigh1.step(signalpart1);//rectify the filtered signal
            signalpart3 = abs(signalpart2);//low pass filter to envelope the emg
            signalpart4 = filterlow1.step(signalpart3);//notch filter to remove 50Hz signal
            signalfinal = filterlow2.step(signalpart4);//2nd low pass filter to envelope the emg
            double signalmeasure = signalfinal;
            if (signalmeasure > maxcal){//determine what the highest reachable emg signal is
                maxcal = signalmeasure;
                }
            }
        calyes=1;
    }  
    }
int main()
{
    pc.baud(115200);
    led1.write(0);
    led2.write(0);
   
        sample_timer.attach(&filter, 0.05);//continously execute the EMG reader and filter
        motor_timer.attach(&checkmotor, 0.05);//continously execute the motor controller
        cal_timer.attach(&calibri, 0.05);//ticker to check if motor is being calibrated
        //0.002

while(1){
 //random while loop to keep system going                                                 
}     
}