#ifndef __main_h
#define __main_h

// BSP defines
#define SYSCLK 96000000
#define EXTCLK 12000000
#define PLLCLK 288000000
#define PLLMULT (PLLCLK/2/EXTCLK)-1
#define TIMER0_FREQ 2
#define TIMER0_DIV (SYSCLK/TIMER0_FREQ)-1
#define RIT_FREQ 10
#define RIT_DIV (SYSCLK/RIT_FREQ)-1
#define MCPWM_FREQ 48000
#define MCPWM_DIV (SYSCLK/MCPWM_FREQ)-1
#define LED_MASK 0x00B40000
#define LED1 0x00040000
#define LED2 0x00100000
#define LED3 0x00200000
#define LED4 0x00800000

typedef union 
{
  struct
  {
    unsigned Timer0_int:1;
    unsigned RIT_int:1;
    unsigned UART0_tx_idle:1;
    unsigned UART0_rx_idle:1;
  };
  unsigned char All_Flags;
} Tinterrupt_flags;

extern Tinterrupt_flags i_flags;

#endif