#include "LPC17xx.h"
#include "core_cm3.h"
#include "cmsis_nvic.h"
#include "Timer0.h"
#include "main.h"
#include "LPC1768.h"

void Timer0_interrupt_enable(void) {

    // Enable Timer0 interrupt
    NVIC_EnableIRQ(TIMER0_IRQn);
}

void Timer0_interrupt_disable(void) {

    // Disable Timer0 interrupt
    NVIC_DisableIRQ(TIMER0_IRQn);
}

void Timer0_IRQHandler(void) {

    // Determine the cause of the interrupt

    // Match register 0 interrupt
    if ((T0IR & T0IR_MR0) == T0IR_MR0)
        T0IR |= T0IR_MR0;
    // Match register 1 interrupt
    if ((T0IR & T0IR_MR1) == T0IR_MR1);
    // Match register 2 interrupt
    if ((T0IR & T0IR_MR2) == T0IR_MR2);
    // Match register 3 interrupt
    if ((T0IR & T0IR_MR3) == T0IR_MR3);
    // Match register 0 interrupt
    if ((T0IR & T0IR_CR0) == T0IR_CR0);
    // Match register 0 interrupt
    if ((T0IR & T0IR_CR1) == T0IR_CR1);

    // Clear the Timer0 interrupt
    NVIC_ClearPendingIRQ(TIMER0_IRQn);

    //Set Timer0 interrupt flag
    i_flags.Timer0_int = 1;
}

void Timer0_init(void) {

    // Set Timer0 interrupt priority
    NVIC_SetPriority(TIMER0_IRQn, 10);

    // Power the Timer0
    Timer0_power_enable();

    // Reset counter
    T0TCR = 2;

    // Select perhiperal clk
    Timer0_select_clk();

    // Timer0 overflow value
    T0MR0 = TIMER0_DIV;

    // Set the prescale register 0
    T0PR = 0;

    // Timer0 is incremented when the prescale register =<
    T0CTCR = 0x0;

    // Set the timer0 reset after reaching T0MR0 and interrupt
    // T0MCR &= ~0x7;
    T0MCR = 0x3;

    // Connect the Timer0 interrupt to the interrupt handler
    NVIC_SetVector(TIMER0_IRQn, (uint32_t)&Timer0_IRQHandler);

    Timer0_interrupt_enable();

    // Enable the counter
    T0TCR = 1 << 0;
}

void Timer0_power_enable(void) {

    // Power the timer0
    PCONP |= PCTIM0;

}

void Timer0_power_disable(void) {

    // Powerdown the timer0
    PCONP &= ~(PCTIM0);

}

void Timer0_select_clk(void) {

    // Including work-around described in errata.lpc1768.pdf R04

    PLL0_disconnect();

    PLL0_disable();

    // Timer0 perhiperal clock select (01 = CCLK)
    PCLKSEL0 &= ~(PCLK_TIMER0_1 | PCLK_TIMER0_0);
    PCLKSEL0 |= PCLK_TIMER0_0;

    PLL0_enable();

    PLL0_connect();

}