#ifndef __LPC1768_h
#define __LPC1768_h

// Define the register names that haven't been defined

// MCPWM
#define MCLIM0 LPC_MCPWM->MCPER0
#define MCLIM1 LPC_MCPWM->MCPER1
#define MCLIM2 LPC_MCPWM->MCPER2

// Perhiperal clock select
#define PCLKSEL0 LPC_SC->PCLKSEL0
#define PCLK_UART1_1 1 << 9
#define PCLK_UART1_0 1 << 8
#define PCLK_UART0_1 1 << 7
#define PCLK_UART0_0 1 << 6
#define PCLK_TIMER1_1 1 << 5
#define PCLK_TIMER1_0 1 << 4
#define PCLK_TIMER0_1 1 << 3
#define PCLK_TIMER0_0 1 << 2
#define PCLK_WDT_1 1 << 1
#define PCLK_WDT_0 1 << 0
#define PCLKSEL1 LPC_SC->PCLKSEL1
#define PCLK_RIT_1 1 << 27
#define PCLK_RIT_0 1 << 26

// Perhiperal power control
#define PCONP LPC_SC->PCONP
#define PCTIM0 1 << 1
#define PCTIM1 1 << 2
#define PCUART0 1 << 3
#define PCUART1 1 << 4
#define PCRIT 1 << 16

// CLKOUT
#define CLKSRCSEL LPC_SC->CLKSRCSEL
#define CCLKCFG LPC_SC->CCLKCFG

// Pin output/input function selection
#define PINSEL0 LPC_PINCON->PINSEL0

// FI0
#define FIOSET LPC_GPIO1->FIOSET
#define FIOCLR LPC_GPIO1->FIOCLR
#define FIOPIN LPC_GPIO1->FIOPIN
#define FIODIR LPC_GPIO1->FIODIR

// PLL0
#define PLL0FEED LPC_SC->PLL0FEED
#define PLL0STAT LPC_SC->PLL0STAT
#define PLL0CFG LPC_SC->PLL0CFG
#define PLL0CON LPC_SC->PLL0CON

// Timer0
#define T0MR0 LPC_TIM0->MR0
#define T0PR LPC_TIM0->PR
#define T0TCR LPC_TIM0->TCR
#define T0CTCR LPC_TIM0->CTCR
#define T0MCR LPC_TIM0->MCR
#define T0IR LPC_TIM0->IR
#define T0IR_MR0 1 << 0
#define T0IR_MR1 1 << 1
#define T0IR_MR2 1 << 2
#define T0IR_MR3 1 << 3
#define T0IR_CR0 1 << 4
#define T0IR_CR1 1 << 5

// UART0
#define U0LCR LPC_UART0->LCR
#define U0DLL LPC_UART0->DLL
#define U0DLM LPC_UART0->DLM
#define U0FDR LPC_UART0->FDR
#define U0FCR LPC_UART0->FCR
#define U0THR LPC_UART0->THR
#define U0RBR LPC_UART0->RBR
#define U0IER LPC_UART0->IER
#define U0IIR LPC_UART0->IIR

// RIT
#define RICOMPVAL LPC_RIT->RICOMPVAL
#define RICTRL LPC_RIT->RICTRL
#define RITINT 1 << 0
#define RITENCLR 1 << 1
#define RITENBR 1 << 2
#define RITEN 1 << 3

extern void PLL0_init(void);
extern void PLL0_disconnect(void);
extern void PLL0_connect(void);
extern void PLL0_disable(void);
extern void PLL0_enable(void);
extern void LED_init(void);

#endif