#include "LPC17xx.h"
#include "core_cm3.h"
#include "cmsis_nvic.h"
#include "Timer0.h"
#include "main.h"
#include "LPC1768.h"
#include "MCPWM.h"
#include "RIT.h"
#include "UART0.h"

// BSP defines see main.h

int  main(void);
void dispatcher(void);

Tinterrupt_flags i_flags;

int main(void) {

    // Set the correct PLL value to match CCLK
    PLL0_init();

    // Enable the driving of the onboard LEDs
    LED_init();

    // Set the timer0, enable it and connect to ISR
    Timer0_init();

    // Set the RIT, enable it and connect to ISR
    RIT_init();

    // Initialize MCPWM
    //MCPWM_init();

    // Initialize UART0
    UART0_init();

    // Start the dispatcher
    dispatcher();

}

void dispatcher(void) {

    int byte;

    while (1) {

        // When the timer0 interrupt occurred
        if (i_flags.Timer0_int == 1) {
            i_flags.Timer0_int = 0;
        }

        // When the RIT interrupt occurred
        if (i_flags.RIT_int == 1) {
            i_flags.RIT_int = 0;
        }

        // When UART0 TX is idle
        if (i_flags.UART0_tx_idle == 1) {
            i_flags.UART0_tx_idle = 0;
        }
        
        // When UART0 RX isn't idle
        if (i_flags.UART0_rx_idle == 0) {
            i_flags.UART0_rx_idle = 1;
            byte = UART0_read();
            if(byte == 'a')
              FIOSET |= LED1;
            else
              FIOCLR |= LED1;
            UART0_write(byte);
        }        
    }

}