#include "LPC17xx.h"
#include "core_cm3.h"
#include "cmsis_nvic.h"
#include "LPC1768.h"
#include "main.h"

void PLL0_init(void) {

    // Set main clk as main oscillator
    CLKSRCSEL = 1;

    PLL0_disconnect();

    PLL0_disable();

    // Set PLL0 multiplier
    PLL0CFG = PLLMULT;

    // Feed the PLL
    PLL0FEED = 0xAA;
    PLL0FEED = 0x55;

    PLL0_enable();

    // Set CPU clock divider
    CCLKCFG = 2;

    // Wait for PLOCK0 to become 1
    while ((PLL0STAT & (1<<26)) == 0x00);

    PLL0_connect();

}

void PLL0_disconnect(void) {

    // Disconnect the PLL0
    PLL0CON &= ~(1<<1); /* Disconnect the main PLL (PLL0) */

    // Feed the PLL
    PLL0FEED = 0xAA;
    PLL0FEED = 0x55;

    // Wait for main PLL (PLL0) to disconnect
    while ((PLL0STAT & (1<<25)) != 0x00);

}

void PLL0_connect(void) {

    // Connect to the main PLL (PLL0)
    PLL0CON |= 1<<1;

    // Feed the PLL
    PLL0FEED = 0xAA;
    PLL0FEED = 0x55;

    // Wait for main PLL (PLL0) to connect
    while ((PLL0STAT & (1<<25)) == 0x00);

}

void PLL0_disable(void) {

    // Turn off the main PLL (PLL0)
    PLL0CON &= ~(1<<0);

    // Feed the PLL
    PLL0FEED = 0xAA;
    PLL0FEED = 0x55;

    // Wait for main PLL (PLL0) to shut down
    while ((PLL0STAT & (1<<24)) != 0x00);

}

void PLL0_enable(void) {

    // Turn on the main PLL (PLL0)
    PLL0CON |= 1<<0;

    // Feed the PLL
    PLL0FEED = 0xAA;
    PLL0FEED = 0x55;

    // Wait for main PLL (PLL0) to come up
    while ((PLL0STAT & (1<<24)) == 0x00);

}

void LED_init(void) {

    // Set output direction for LEDs
    FIODIR |= LED_MASK;

}

