#include "LPC17xx.h"
#include "core_cm3.h"
#include "cmsis_nvic.h"
#include "RIT.h"
#include "main.h"
#include "LPC1768.h"

void RIT_interrupt_enable(void) {

    // Enable RIT interrupt
    NVIC_EnableIRQ(RIT_IRQn);
}

void RIT_interrupt_disable(void) {

    // Disable RIT interrupt
    NVIC_DisableIRQ(RIT_IRQn);
}

void RIT_IRQHandler(void) {

    // Determine the cause of the interrupt

    // RIT interrupt occured
    if((RICTRL & RITINT) == RITINT)
      RICTRL |= RITINT;

    // Clear the RIT interrupt
    NVIC_ClearPendingIRQ(RIT_IRQn);

    //Set RIT interrupt flag
    i_flags.RIT_int = 1;
}

void RIT_init(void) {

    // Set RIT interrupt priority
    NVIC_SetPriority(RIT_IRQn, 11);

    // Power the RIT
    RIT_power_enable();
    
    // Set the RIT compare value
    RICOMPVAL = RIT_DIV;
    
    // Select perhiperal clk
    RIT_select_clk();    
    
    // Set counter clear after interrupt
    RICTRL |= RITENCLR;

    // Connect the RIT interrupt to the interrupt handler
    NVIC_SetVector(RIT_IRQn, (uint32_t)&RIT_IRQHandler);

    // Enable the RIT interrupt
    RIT_interrupt_enable();

    // Enable the RIT
    RICTRL |= RITEN;
}

void RIT_power_enable(void) {

    // Power the TRIT
    PCONP |= PCRIT;

}

void RIT_power_disable(void) {

    // Powerdown the RIT
    PCONP &= ~(PCRIT);

}

void RIT_select_clk(void) {

    // Including work-around described in errata.lpc1768.pdf R04

    PLL0_disconnect();

    PLL0_disable();

    // Timer0 perhiperal clock select (01 = CCLK)
    PCLKSEL1 &= ~(PCLK_RIT_1 | PCLK_RIT_0);
    PCLKSEL1 |= PCLK_RIT_0;

    PLL0_enable();

    PLL0_connect();

}