#ifndef GAME_H
#define GAME_H

/** @file Game.h
*   @author Andreas Garmannslund
*/

#include "State.h"
#include "Sprites.h"
#include "ShiftReg.h"
#include "Global.h"
#include <sstream>

/// State: Game
class Game : public State
{
    public:
        /// Creates the Game state
        Game(StateManager* fsm, N5110 *lcd, InputManager* input, Sound *sound, ShiftReg *shiftreg)
                : State(fsm, lcd, input, sound, shiftreg) 
                {
                    gameProperty.currentLayer = 1;
                    clearAll();
                    init();
                }
                
        /// Deconstructor: Frees all memory that was temporarely allocated by the Game state.
        ~Game();
                                
        /// Handle input and update logic.
        virtual void update(float dt);
        
        /// Draw state to lcd.
        virtual void render();
        
        
    private:
        void init();    // Sets some initial values
        void spawnEnemy();  // Spawns a new enemy
        void moveEnemies(); // Movement and AI for all enemies
        void moveWithCollisionTest(Entity* entity, const bool map[HEIGHT][WIDTH]); // Moves entity in map. If collision occurs, entity can not move further.
        bool hitTestRect(Rectangle r1, Rectangle r2); // Returns true if two rectangles overlap @see https://developer.mozilla.org/en-US/docs/Games/Techniques/2D_collision_detection#Axis-Aligned_Bounding_Box
        bool bulletHitMap(Rectangle &bulletColRect, const bool map[HEIGHT][WIDTH]); // Help function for detecting collision between moving bullet and map.
        void renderScore(); // Draws the current score in upper right corner
        void respawnPlayer(); // Respawns player at start position
        void clearAll(); // Clear all entities
    
        Map::MapProperty mapProperty;
        GameX::GameProperty gameProperty;
        
        ShiftReg shift;
        
        bool releasedBtnB;  // True if button B has been released after being pressed down
        bool releasedBtnC;  // True if button C has been released after being pressed down
        bool releasedBtnD;  // True if button D has been released after being pressed down
};

#endif
