#ifndef ACHIEVEMENT_H
#define ACHIEVEMENT_H

#include "State.h"
#include "Global.h"
#include <cstdlib>
#include <string>
#include <sstream>

/// @file Achievement.h

/// State: Submit Highscore
/// Displays a screen where the user is promted to input his or her initials
class Achievement : public State
{
    public:
        Achievement(StateManager* fsm, N5110 *lcd, InputManager* input, Sound* sound, ShiftReg* shiftreg)
                : State(fsm, lcd, input, sound, shiftreg) {init();}
        
        void init();
        /// Update logic
        virtual void update(float dt);
        /// Draw to screen
        virtual void render();
    
    private:
        static void btnAPress(); /// Interrupt callback function when button A is pressed
        static void btnBPress(); /// Interrupt callback function when button B is pressed
        static void btnCPress(); /// Interrupt callback function when button C is pressed
        static void btnDPress(); /// Interrupt callback function when button D is pressed
        
    private:
        enum SubmitHighscoreState{LETTER1, LETTER2, LETTER3, SEL_SUBMIT, WRITE_TO_FILE, LOAD_GAME_OVER};
        
        static int currentState;
        /** Changes the current selected letter.
          * @param index The index of the letter to be changed (0, 1 or 2)
          * @param next Goes to the next letter in the alphabet if true. Goes to the previous letter if false.
        */
        static void changeLetter(int index, bool next);
        
        static int letters[3];
};

#endif