#include "StateManager.h"

/// @file StateManager.cpp

void StateManager::changeState(MainState newState)
{
    if (currentState != 0)      // if a state exist
        delete currentState;    // delete the old state

    // Create new state
    switch (newState)
    {
        case MAIN_MENU:
            currentState = new MainMenu(this, lcd, input, sound, shiftreg);
        break;
        
        case GAME:
            currentState = new Game(this, lcd, input, sound, shiftreg);
        break;
        
        case TITLE_SCREEN:
            currentState = new CoverPage(this, lcd, input, sound, shiftreg);
        break;
        
        case SUBMIT_HIGHSCORE:
            currentState = new Achievement(this, lcd, input, sound, shiftreg);
        break;
        
        case GAME_OVER:
            currentState = new GameOver(this, lcd, input, sound, shiftreg);
        break;

        default:
            ; // error: this shouldn't happen
    }
}

void StateManager::requestStateChange(MainState requestedState)
{
    if (nextState != NO_STATE)
        error("Invalid - can't request new state before the first request has been processed!");
        
    nextState = requestedState;
}

void StateManager::update(float dt)
{       
    currentState->update(dt);
}

void StateManager::render()
{
    currentState->render();
}

void StateManager::processRequest()
{
    // Check if there has been a request to change the state
    if (nextState != NO_STATE)
    {
        changeState(nextState);
        nextState = NO_STATE;       // reset, state has been changed
    }
}