#ifndef GAME_OVER_H
#define GAME_OVER_H

/** @file GameOver.h
*   @author Andreas Garmannslund
*   @date May 2015
*/

#include "State.h"
#include "Sprites.h"

/// State: Game Over
class GameOver : public State
{
    public:
        /// Create a new GameOver object.
        GameOver(StateManager* fsm, N5110 *lcd, InputManager* input, Sound* sound, ShiftReg* shiftreg)
                : State(fsm, lcd, input, sound, shiftreg) {init();}
                
        /// Update logic
        virtual void update(float dt);
        
        /// Draw to lcd
        virtual void render();          
    
    private:
        /// Setup initial configuration.
        void init();
        
         /// Interrupt callback function when button A is pressed.
        static void btnAPress();
        
        /// Interrupt callback function when button C is pressed.
        static void btnCPress();
        
    private:
        /// Internal states
        enum GameOverState {SELECT_PLAY, SELECT_MAIN_MENU, LOAD_GAME, LOAD_MAIN_MENU};
        
        /// Current internal state
        static int currentState;    
};

#endif