#include "MainMenu.h"

/// @file MainMenu.cpp

/// States for the Main Menu's internal finite state machine
enum MenuState {SELECT_PLAY, SELECT_HIGHSCORES, SELECT_CONTROLS, LOAD_GAME, HIGHSCORES, CONTROLS};

/// Static variables for internal fsm.

const int MainMenu::MENU_FSM[6][3] = {
    {LOAD_GAME, SELECT_PLAY, SELECT_HIGHSCORES},            // State: SELECT_PLAY
    {HIGHSCORES, SELECT_HIGHSCORES, SELECT_CONTROLS},       // State: SELECT_HIGHSCORES
    {CONTROLS, SELECT_CONTROLS, SELECT_PLAY},               // State: SELECT_CONTROLS
    {LOAD_GAME, LOAD_GAME, LOAD_GAME},                      // State: LOAD_GAME
    {SELECT_HIGHSCORES, SELECT_HIGHSCORES, HIGHSCORES},     // State: HIGHSCORES
    {SELECT_CONTROLS, SELECT_CONTROLS, CONTROLS}            // State: CONTROLS
};

int MainMenu::currentState; /// Current state for the state machine

// Callback functions (needs to be static)
void MainMenu::btnAPress()
{
    currentState = MENU_FSM[currentState][0];
}

void MainMenu::btnBPress()
{
    currentState = MENU_FSM[currentState][1];
}

void MainMenu::btnCPress()
{
    currentState = MENU_FSM[currentState][2];
}

void MainMenu::btnDPress()
{
    currentState = MENU_FSM[currentState][2];
}

void MainMenu::init()
{
    MainMenu::currentState = SELECT_PLAY;
    input->addBtnPressInterrupt(Input::ButtonA, &btnAPress);
    input->addBtnPressInterrupt(Input::ButtonB, &btnBPress);
    input->addBtnPressInterrupt(Input::ButtonC, &btnCPress);
    input->addBtnPressInterrupt(Input::ButtonD, &btnDPress);
}

void MainMenu::update(float dt) {} // Does not do anything as program flow is controlled by interrupts, but needs to be defined as it is a virtual function.

void MainMenu::render()
{   
    for (int i = 0; i < HEIGHT/3; ++i)
    {
        drawImage(Image::Pattern3, 0, 3*i);           // left border
        drawImage(Image::Pattern3, (WIDTH-3), 3*i);   // right border
    }
    
    for (int j = 0; j < WIDTH/3; ++j)
    {
        drawImage(Image::Pattern3, 3 * j, (HEIGHT-3));    // bottom border
        drawImage(Image::Pattern3, 3 * j, 0);             // top border
    }
    
    // Check sate
    int xMargin = 8;
    switch (currentState)
    {        
        case SELECT_PLAY:
            lcd->printString(">Play", xMargin, 1);
            lcd->printString("High Scores", xMargin, 2);
            lcd->printString("Controls", xMargin, 3);
        break;
        
        case SELECT_HIGHSCORES:
            lcd->printString("Play", xMargin, 1);
            lcd->printString(">High Scores", xMargin, 2);
            lcd->printString("Controls", xMargin, 3);
        break;
        
        case SELECT_CONTROLS:
            lcd->printString("Play", xMargin, 1);
            lcd->printString("High Scores", xMargin, 2);
            lcd->printString(">Controls", xMargin, 3);
        break;
        
        case HIGHSCORES:
            
            for (int i = 0; i < 3; ++i)
            {
                std::stringstream ss;
                ss << Global::highscores[i].initials << "  " << Global::highscores[i].score;
                lcd->printString(ss.str().c_str(), xMargin, i+1);
            }
            

            lcd->printString(">Back", xMargin, 4);
        break;
        
        case CONTROLS:
            lcd->printString("A: Jump", xMargin, 1);
            lcd->printString("B: Shoot", xMargin, 2);
            lcd->printString("C: Pause", xMargin, 3);
            lcd->printString(">Back", xMargin, 4);
        break;
        
        case LOAD_GAME:
            lcd->printString("Loading...", xMargin, 2);
            requestStateChange(GAME);
        break;
        
        default:
        ;
            //error("MainMenu: Invalid internal state");
            
    }
}