#include "GameOver.h"

/// @file GameOver.cpp

int GameOver::currentState = SELECT_PLAY;

void GameOver::init()
{
    input->addBtnPressInterrupt(Input::ButtonA, &btnAPress);
    input->addBtnPressInterrupt(Input::ButtonC, &btnCPress);
}

void GameOver::update(float dt)
{
    switch (currentState)
    {
        case LOAD_GAME:
            requestStateChange(GAME);
        break;
        
        case LOAD_MAIN_MENU:
            requestStateChange(MAIN_MENU);
        break;
    }
}

void GameOver::btnAPress()
{
    switch(GameOver::currentState)
    {
        case SELECT_PLAY:
            currentState = LOAD_GAME;
        break;
        
        case SELECT_MAIN_MENU:
            currentState = LOAD_MAIN_MENU;
        break;
    }
}

void GameOver::btnCPress()
{
    ++currentState %= 2; // go to next state (only 2 states in total)
}

void GameOver::render()
{
    // Draw border
    for (int i = 0; i < HEIGHT/3; ++i)
    {
        drawImage(Image::Pattern3, 0, 3*i);           // left border
        drawImage(Image::Pattern3, (WIDTH-3), 3*i);   // right border
    }
    
    for (int j = 0; j < WIDTH/3; ++j)
    {
        drawImage(Image::Pattern3, 3 * j, (HEIGHT-3));    // bottom border
        drawImage(Image::Pattern3, 3 * j, 0);             // top border
    }
    
    // Draw text
    int xMargin = 8;
    lcd->printString("Game Over!", xMargin, 1);
    
    switch (currentState)
    {        
        case SELECT_PLAY:
            lcd->printString(">Play again", xMargin, 3);
            lcd->printString("Menu", xMargin, 4);
        break;
        
        case SELECT_MAIN_MENU:
            lcd->printString("Play again", xMargin, 3);
            lcd->printString(">Menu", xMargin, 4);
        break;           
        
        case LOAD_GAME:
        case LOAD_MAIN_MENU:
            lcd->printString("Loading...", 0, 2);
        break; 
    }
}