#ifndef TITLE_SCREEN_H
#define TITLE_SCREEN_H

#include "State.h"

/// @file CoverPage.h

/// Used to display the splash screen which is shown when turning the device on.
class CoverPage : public State
{
    public:
        CoverPage(StateManager* fsm, N5110 *lcd, InputManager* input, Sound* sound, ShiftReg* shiftreg)
                : State(fsm, lcd, input, sound, shiftreg) {init();}
        
        virtual void update(float dt);
        virtual void render();
        
    private:
        void init();
        static void btnPress();
        static const bool splashScreen[48][84];
        static bool btnWasPressed;
        
};

#endif