#include "wait.h"

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void wait(float s)
{
    unistd::usleep(s * 1000 * 1000);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void wait_ms(int ms)
{
    unistd::usleep(ms * 1000);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void wait_us(int us)
{
    if (us > 100) {
        struct timespec tim, tim2;
        tim.tv_sec = 0;
        tim.tv_nsec = us * 1000;

        if (nanosleep(&tim, &tim2) < 0) {
            fprintf(stderr, "Nano sleep system call failed \n");
            exit(1);
        }
    }
    else {
        struct timeval  tNow, tLong, tEnd;

        gettimeofday(&tNow, NULL);
        tLong.tv_sec = us / 1000000;
        tLong.tv_usec = us % 1000000;
        timeradd(&tNow, &tLong, &tEnd);

        while (timercmp(&tNow, &tEnd, < ))
            gettimeofday(&tNow, NULL);
    }
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
uint64_t millis()
{
    return bcm2835_systimer_read() / 1000;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void bcm2835_delay(unsigned int millis)
{
    struct timespec sleeper;

    sleeper.tv_sec = (time_t) (millis / 1000);
    sleeper.tv_nsec = (long)(millis % 1000) * 1000000;
    nanosleep(&sleeper, NULL);
}
