
#include "mbed.h"

/**
 * @brief
 * @note
 * @param
 * @retval
 */
Timer::Timer() :
    _start(0),
    _stop(0),
    _running(false)
{ }

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void Timer::start()
{
    _start = bcm2835_systimer_read();
    _running = true;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void Timer::stop()
{
    _stop = bcm2835_systimer_read();
    _running = false;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
void Timer::reset()
{
    _stop = bcm2835_systimer_read();
    _start = _stop;
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
uint64_t Timer::read_us()
{
    if (_running)
        return(bcm2835_systimer_read() - _start);
    else
        return(_stop - _start);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
uint64_t Timer::read_ms()
{
    return read_us() / 1000;
}

